/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.coodex.concrete.apitools.APIHelper;
import org.coodex.concrete.apitools.ConcreteAPIRenderer;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.modules.AbstractModule;
import org.coodex.config.Config;
import org.coodex.util.Common;
import org.coodex.util.LazyServiceLoader;
import org.coodex.util.ServiceLoader;

public class API {
    private static final ServiceLoader<ConcreteAPIRenderer<?>> RENDERS = new LazyServiceLoader<ConcreteAPIRenderer<?>>(){};
    private static final String TAG_API_GENERATOR = "api_gen";

    public static void generate(String desc, String path, String ... packages) throws IOException {
        API.generate(null, desc, path, packages);
    }

    public static void generate(Map<String, Object> ext, String desc, String path, String ... packages) throws IOException {
        if (packages == null) {
            packages = ConcreteHelper.getApiPackages();
        }
        API.generate(ext, desc, path, APIHelper.loadModules(desc, packages));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generate(Map<String, Object> ext, String desc, String path, List<? extends AbstractModule<?>> modules) throws IOException {
        if (RENDERS.getAll().size() == 0) {
            throw new RuntimeException("NONE render found.");
        }
        Iterator iterator = RENDERS.getAll().values().iterator();
        while (iterator.hasNext()) {
            ConcreteAPIRenderer render;
            ConcreteAPIRenderer concreteAPIRenderer = render = (ConcreteAPIRenderer)iterator.next();
            synchronized (concreteAPIRenderer) {
                if (render.isAccept(desc)) {
                    render.setRoot(path);
                    render.setExt(ext);
                    render.render((List)Common.cast(modules));
                    return;
                }
            }
        }
        throw new RuntimeException("NONE render for " + desc + " found.");
    }

    public static void generate(Map<String, Object> ext, String desc, String path, Class<?> ... classes) throws IOException {
        if (classes == null) {
            API.generate(ext, desc, path, (String[])null);
            return;
        }
        API.generate(ext, desc, path, APIHelper.loadModules(desc, classes));
    }

    public static void generateFor(String module, String ... packages) throws IOException {
        String desc = Config.get((String)"desc", (String[])new String[]{TAG_API_GENERATOR, module});
        String path = Config.get((String)"path", (String[])new String[]{TAG_API_GENERATOR, module});
        API.generate(API.toMap(Config.get((String)"ext", (String[])new String[]{TAG_API_GENERATOR, module})), desc, path, packages);
    }

    public static void generateFor(String module, Class<?> ... classes) throws IOException {
        String desc = Config.get((String)"desc", (String[])new String[]{TAG_API_GENERATOR, module});
        String path = Config.get((String)"path", (String[])new String[]{TAG_API_GENERATOR, module});
        API.generate(API.toMap(Config.get((String)"ext", (String[])new String[]{TAG_API_GENERATOR, module})), desc, path, classes);
    }

    private static Map<String, Object> toMap(String json) {
        if (json == null) {
            return new HashMap<String, Object>();
        }
        return (Map)JSON.parseObject((String)json, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
    }
}

