/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ErrorMessageFacade;
import org.coodex.concrete.common.modules.AbstractModule;
import org.coodex.concrete.common.modules.ModuleMaker;
import org.coodex.util.Common;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.SelectableServiceLoader;

public class APIHelper {
    private static final SelectableServiceLoader<String, ModuleMaker<?>> MODULE_MAKERS = new LazySelectableServiceLoader<String, ModuleMaker<?>>(){};

    private static ModuleMaker<?> getInstance(String desc) {
        ModuleMaker moduleMaker = (ModuleMaker)MODULE_MAKERS.select((Object)desc);
        if (moduleMaker == null) {
            throw new RuntimeException("No module maker supported '" + desc + "' ");
        }
        return moduleMaker;
    }

    public static <MODULE extends AbstractModule<?>> List<MODULE> loadModules(String desc, String ... packages) {
        ModuleMaker maker = (ModuleMaker)Common.cast(APIHelper.getInstance(desc));
        return APIHelper.loadModules(maker, packages);
    }

    public static <M extends AbstractModule<?>> List<M> loadModules(String desc, Class<?> ... classes) {
        ModuleMaker maker = (ModuleMaker)Common.cast(APIHelper.getInstance(desc));
        return APIHelper.loadModules(maker, classes);
    }

    private static <MODULE extends AbstractModule<?>> List<MODULE> loadModules(ModuleMaker<MODULE> maker, Class<?> ... classes) {
        ForEachClassConsumer consumer = new ForEachClassConsumer(maker);
        Arrays.stream(classes).forEach(consumer.classConsumer);
        return consumer.toList();
    }

    private static <MODULE extends AbstractModule<?>> List<MODULE> loadModules(ModuleMaker<MODULE> maker, String ... packages) {
        ForEachClassConsumer consumer = new ForEachClassConsumer(maker);
        ConcreteHelper.foreachClassInPackages((Consumer)consumer.classConsumer, (String[])packages);
        return consumer.toList();
    }

    private static class ForEachClassConsumer<MODULE extends AbstractModule<?>> {
        private final ModuleMaker<MODULE> maker;
        private final Map<Class<?>, MODULE> moduleMap = new HashMap();
        private final Consumer<Class<?>> classConsumer = serviceClass -> {
            if (ConcreteHelper.isConcreteService((Class)serviceClass)) {
                AbstractModule module = this.getMaker().make(serviceClass);
                Class key = module.getInterfaceClass();
                AbstractModule exists = (AbstractModule)this.moduleMap.get(key);
                if (exists != null) {
                    throw new RuntimeException(String.format("Module %s duplicated. %s & %s", key, exists.getInterfaceClass().getName(), module.getInterfaceClass().getName()));
                }
                this.moduleMap.put(key, module);
            } else {
                ErrorMessageFacade.register((Class)serviceClass);
            }
        };

        private ForEachClassConsumer(ModuleMaker<MODULE> maker) {
            this.maker = maker;
        }

        private ModuleMaker<MODULE> getMaker() {
            return this.maker;
        }

        private List<MODULE> toList() {
            ArrayList<MODULE> moduleList = new ArrayList<MODULE>(this.moduleMap.values());
            Collections.sort(moduleList);
            return moduleList;
        }
    }
}

