/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools.jaxrs.service;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.coodex.concrete.apitools.jaxrs.DocToolkit;
import org.coodex.concrete.apitools.jaxrs.service.AbstractServiceDocRenderer;
import org.coodex.concrete.apitools.jaxrs.service.ServiceDocToolkit;
import org.coodex.concrete.common.ErrorMessageFacade;
import org.coodex.concrete.jaxrs.struct.JaxrsModule;

public class VuePressDocRenderer
extends AbstractServiceDocRenderer {
    public static final String RENDER_NAME = "JaxRS.doc.backend.vuepress.v1";
    private static final String RESOURCE_PACKAGE = "concrete/templates/jaxrs/services/doc/vuepress/v1/";
    private ServiceDocToolkit toolkit;

    @Override
    protected DocToolkit getToolkit() {
        return this.toolkit;
    }

    @Override
    protected String getTemplatePath() {
        return RESOURCE_PACKAGE;
    }

    @Override
    protected String getRenderName() {
        return RENDER_NAME;
    }

    @Override
    public void render(List<JaxrsModule> modules) throws IOException {
        if (!this.exists("package.json")) {
            this.copyTo("package.json", "package.json");
        }
        if (!this.exists(".gitignore")) {
            this.writeTo(".gitignore", "node_modules\n.temp\n.cache\ndist");
        }
        if (!this.exists("docs/.vuepress/config.ts")) {
            this.copyTo("config_ts.ftl", "docs/.vuepress/config.ts");
        }
        if (!this.exists("docs/.vuepress/styles/index.scss")) {
            this.writeTo("docs/.vuepress/styles/index.scss", ":root{\n    --content-width: 960px;\n}");
        }
        if (!this.exists("docs/README.md")) {
            this.copyTo("README.md", "docs/README.md");
        }
        this.toolkit = new ServiceDocToolkit(this, "docs");
        this.writeModuleList(modules, "docs");
        for (JaxrsModule module : modules) {
            this.writeModule(module, "docs");
        }
        this.writeErrorInfo(ErrorMessageFacade.getAllErrorInfo(), "docs");
        this.writeTo("docs/.vuepress/modules.json", JSON.toJSONString(modules.stream().map(m -> "/modules/" + m.getInterfaceClass().getName()).collect(Collectors.toList())));
        this.writeTo("docs/.vuepress/pojos.json", JSON.toJSONString(this.toolkit.getPojos().stream().sorted().map(s -> "/pojos/" + s).collect(Collectors.toList())));
    }
}

