/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools.jaxrs.axios;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.coodex.concrete.apitools.AbstractRenderer;
import org.coodex.concrete.apitools.jaxrs.JaxrsRenderHelper;
import org.coodex.concrete.common.modules.AbstractModule;
import org.coodex.concrete.jaxrs.struct.JaxrsModule;
import org.coodex.concrete.jaxrs.struct.JaxrsParam;
import org.coodex.concrete.jaxrs.struct.JaxrsUnit;
import org.coodex.util.Common;

public class AxiosCodeRenderer
extends AbstractRenderer<JaxrsModule> {
    public static final String RENDER_NAME = "JaxRS.code.axios.js.v1";
    private static final String RESOURCE_PACKAGE = "concrete/templates/jaxrs/axios/code/v1/";

    @Override
    protected String getTemplatePath() {
        return RESOURCE_PACKAGE;
    }

    @Override
    protected String getRenderName() {
        return RENDER_NAME;
    }

    @Override
    public void render(List<JaxrsModule> modules) throws IOException {
        String moduleName = this.getRenderDesc().substring(RENDER_NAME.length());
        moduleName = Common.isBlank((String)moduleName) ? "concrete" : moduleName.substring(1);
        HashMap<String, Object> versionAndStyle = new HashMap<String, Object>();
        versionAndStyle.put("version", "0.5.1-RC4");
        this.writeTo("jaxrs/concrete.js", "concrete.ftl", versionAndStyle);
        for (JaxrsModule module : modules) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("moduleName", moduleName);
            param.put("serviceName", module.getInterfaceClass().getSimpleName());
            HashMap<String, HashMap<String, String>> methods = new HashMap<String, HashMap<String, String>>();
            for (JaxrsUnit unit : (JaxrsUnit[])module.getUnits()) {
                String methodName = unit.getMethod().getName();
                HashMap<String, String> method = (HashMap<String, String>)methods.get(methodName);
                if (method == null) {
                    method = new HashMap<String, String>();
                    method.put("name", methodName);
                    methods.put(methodName, method);
                }
                method.put("jsdoc", JaxrsRenderHelper.getDoc(unit));
                ArrayList overloads = (ArrayList)Common.cast(method.get("overloads"));
                if (overloads == null) {
                    overloads = new ArrayList();
                    method.put("overloads", (String)((Object)overloads));
                }
                HashMap<String, Object> overload = new HashMap<String, Object>();
                overloads.add(overload);
                ArrayList<String> params = new ArrayList<String>();
                for (JaxrsParam p : (JaxrsParam[])unit.getParameters()) {
                    params.add(p.getName());
                }
                overload.put("paramCount", ((JaxrsParam[])unit.getParameters()).length);
                overload.put("params", params);
                overload.put("body", JaxrsRenderHelper.getBody(unit));
                overload.put("url", JaxrsRenderHelper.getMethodPath((AbstractModule<JaxrsUnit>)module, unit));
                overload.put("resultType", String.class.equals((Object)unit.getReturnType()) ? "text" : "json");
                overload.put("httpMethod", unit.getInvokeType());
            }
            param.put("methods", methods.values());
            this.writeTo("jaxrs/" + moduleName + "/" + module.getInterfaceClass().getName() + ".js", "service.ftl", param);
        }
    }
}

