/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import org.coodex.concrete.apitools.ConcreteAPIRenderer;
import org.coodex.concrete.common.modules.AbstractModule;
import org.coodex.util.Common;

public abstract class AbstractRenderer<M extends AbstractModule<?>>
implements ConcreteAPIRenderer<M> {
    protected static final String FS = Common.FILE_SEPARATOR;
    private Configuration configuration;
    private String rootToWrite;
    private String desc;
    private Map<String, Object> ext = null;

    protected String getRenderDesc() {
        return this.desc;
    }

    @Override
    public void setRoot(String rootPath) {
        this.rootToWrite = rootPath;
    }

    private synchronized Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
            this.configuration.setClassLoaderForTemplateLoading(this.getClass().getClassLoader(), this.getTemplatePath());
        }
        return this.configuration;
    }

    protected abstract String getTemplatePath();

    protected abstract String getRenderName();

    @Override
    public boolean isAccept(String desc) {
        this.desc = desc;
        String renderName = this.getRenderName();
        if (renderName == null) {
            return false;
        }
        return desc != null && desc.toLowerCase().startsWith(renderName.toLowerCase());
    }

    private Template getTemplate(String templateName) throws IOException {
        return this.getConfiguration().getTemplate(templateName);
    }

    public void writeTo(String filePath, String content) throws IOException {
        File target = Common.newFile((String)(this.rootToWrite + FS + filePath));
        try (OutputStreamWriter outputStream = new OutputStreamWriter(Files.newOutputStream(target.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            outputStream.write(content);
        }
    }

    public void writeTo(String filePath, String templateName, String pojoKey, Object value) throws IOException {
        this.writeTo(filePath, templateName, pojoKey, value, null);
    }

    public void writeTo(String filePath, String templateName, String pojoKey, Object value, Object toolKit) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(pojoKey, value);
        if (toolKit != null) {
            map.put("tool", toolKit);
        }
        this.writeTo(filePath, templateName, map);
    }

    protected Map<String, Object> merge(Map<String, Object> map) {
        if (this.ext == null || this.ext.size() == 0) {
            return map;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (map != null) {
            result.putAll(map);
        }
        result.putAll(this.ext);
        return result;
    }

    public void writeTo(String filePath, String templateName, Map<String, Object> map) throws IOException {
        Template template = this.getTemplate(templateName);
        File target = Common.newFile((String)(this.rootToWrite + FS + filePath));
        try (OutputStreamWriter outputStream = new OutputStreamWriter(Files.newOutputStream(target.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            template.process(this.merge(map), (Writer)outputStream);
        }
        catch (TemplateException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    protected boolean exists(String file) {
        return new File(this.rootToWrite + FS + file).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyTo(String resourceName, String path) throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.getTemplatePath() + resourceName);
        if (inputStream == null) {
            throw new IOException("not found: " + this.getTemplatePath() + resourceName);
        }
        try {
            File target = Common.newFile((String)(this.rootToWrite + FS + path));
            try (OutputStream targetStream = Files.newOutputStream(target.toPath(), new OpenOption[0]);){
                Common.copyStream((InputStream)inputStream, (OutputStream)targetStream);
            }
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public void setExt(Map<String, Object> ext) {
        this.ext = ext;
    }
}

