/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools.jaxrs;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.coodex.concrete.api.Description;
import org.coodex.util.Common;
import org.coodex.util.Described;
import org.coodex.util.JSONSerializer;
import org.coodex.util.Valuable;

public class EnumElementInfo {
    private final String label;
    private final String desc;
    private final String key;
    private final String value;
    private final boolean str;

    public EnumElementInfo(Enum<?> enumElement) {
        this.key = enumElement.name();
        Optional<Description> description = EnumElementInfo.getAnnotation(enumElement, Description.class);
        this.label = EnumElementInfo.getLabelFromEnum(enumElement, description);
        this.desc = description.map(Description::description).orElse("--");
        if (enumElement instanceof Valuable) {
            Valuable v = (Valuable)enumElement;
            Object value = v.getValue();
            this.str = value instanceof String;
            this.value = this.str ? (String)value : JSONSerializer.getInstance().toJson(value);
        } else {
            this.str = true;
            this.value = enumElement.name();
        }
    }

    private static <A extends Annotation> Optional<A> getAnnotation(Enum<?> enumElement, Class<A> annotationClass) {
        try {
            return Optional.ofNullable(enumElement.getClass().getField(enumElement.name()).getAnnotation(annotationClass));
        }
        catch (NoSuchFieldException e) {
            return Optional.empty();
        }
    }

    private static String getLabelFromEnum(Enum<?> enumElement, Optional<Description> annotationOptional) {
        return (String)Common.firstValuable((Object[])new String[]{annotationOptional.map(Description::name).orElse(null), Described.getDesc(enumElement), enumElement.name()});
    }

    public static List<EnumElementInfo> of(Class<Enum<?>> enumClass) {
        return Stream.of(enumClass.getEnumConstants()).map(EnumElementInfo::new).collect(Collectors.toList());
    }

    public String getCodeValue() {
        return this.str ? JSONSerializer.getInstance().toJson((Object)this.value) : this.value;
    }

    public String getLabel() {
        return this.label;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isStr() {
        return this.str;
    }

    public String getDesc() {
        return this.desc;
    }
}

