/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.coodex.concrete.apitools.APIHelper;
import org.coodex.concrete.apitools.ConcreteAPIRenderer;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.modules.AbstractModule;
import org.coodex.config.Config;
import org.coodex.exception.NoneInstanceException;
import org.coodex.exception.NoneSupportedException;
import org.coodex.util.Common;
import org.coodex.util.JSONSerializer;
import org.coodex.util.LazyServiceLoader;
import org.coodex.util.ServiceLoader;

public class API {
    private static final ServiceLoader<ConcreteAPIRenderer<?>> RENDERS = new LazyServiceLoader<ConcreteAPIRenderer<?>>(){};
    private static final String TAG_API_GENERATOR = "api_gen";
    private final Set<String> packages = new HashSet<String>();
    private final Set<Class<?>> classSet = new HashSet();
    private final String desc;
    private final String path;
    private final Map<String, Object> ext = new HashMap<String, Object>();

    private API(Builder builder) {
        this.desc = builder.desc;
        this.packages.addAll(builder.packages);
        this.classSet.addAll(builder.classSet);
        this.path = builder.path;
        this.ext.putAll(builder.ext);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Deprecated
    public static void generate(String desc, String path, String ... packages) throws IOException {
        API.generate(null, desc, path, packages);
    }

    @Deprecated
    public static void generate(Map<String, Object> ext, String desc, String path, String ... packages) throws IOException {
        API.generate(ext, desc, path, APIHelper.loadModules(desc, packages));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static void generate(Map<String, Object> ext, String desc, String path, List<? extends AbstractModule<?>> modules) throws IOException {
        if (RENDERS.getAll().size() == 0) {
            throw new RuntimeException("NONE render found.");
        }
        Iterator iterator = RENDERS.getAll().values().iterator();
        while (iterator.hasNext()) {
            ConcreteAPIRenderer render;
            ConcreteAPIRenderer concreteAPIRenderer = render = (ConcreteAPIRenderer)iterator.next();
            synchronized (concreteAPIRenderer) {
                if (render.isAccept(desc)) {
                    render.setRoot(path);
                    render.setExt(ext);
                    render.render((List)Common.cast(modules));
                    return;
                }
            }
        }
        throw new RuntimeException("NONE render for " + desc + " found.");
    }

    @Deprecated
    public static void generate(Map<String, Object> ext, String desc, String path, Class<?> ... classes) throws IOException {
        if (classes == null) {
            API.generate(ext, desc, path, (String[])null);
            return;
        }
        API.generate(ext, desc, path, APIHelper.loadModules(desc, classes));
    }

    @Deprecated
    public static void generateFor(String module, String ... packages) throws IOException {
        String desc = Config.get((String)"desc", (String[])new String[]{TAG_API_GENERATOR, module});
        String path = Config.get((String)"path", (String[])new String[]{TAG_API_GENERATOR, module});
        API.generate(API.toMap(Config.get((String)"ext", (String[])new String[]{TAG_API_GENERATOR, module})), desc, path, packages);
    }

    @Deprecated
    public static void generateFor(String module, Class<?> ... classes) throws IOException {
        String desc = Config.get((String)"desc", (String[])new String[]{TAG_API_GENERATOR, module});
        String path = Config.get((String)"path", (String[])new String[]{TAG_API_GENERATOR, module});
        API.generate(API.toMap(Config.get((String)"ext", (String[])new String[]{TAG_API_GENERATOR, module})), desc, path, classes);
    }

    private static Map<String, Object> toMap(String json) {
        if (json == null) {
            return new HashMap<String, Object>();
        }
        return (Map)JSONSerializer.getInstance().parse(json, Map.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException {
        if (RENDERS.getAll().size() == 0) {
            throw new NoneInstanceException("NONE render found.");
        }
        Iterator iterator = RENDERS.getAll().values().iterator();
        while (iterator.hasNext()) {
            ConcreteAPIRenderer render;
            ConcreteAPIRenderer concreteAPIRenderer = render = (ConcreteAPIRenderer)iterator.next();
            synchronized (concreteAPIRenderer) {
                if (render.isAccept(this.desc)) {
                    render.setRoot(this.path);
                    render.setExt(this.ext);
                    render.render((List)Common.cast(this.getModules()));
                    return;
                }
            }
        }
        throw new NoneSupportedException("NONE render for " + this.desc + " found.");
    }

    private void deleteFiles(File file) {
        File[] files;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null && files.length > 0) {
            for (File f : files) {
                this.deleteFiles(f);
            }
        }
        file.delete();
    }

    private void cleanDir() {
        this.deleteFiles(new File(this.path));
    }

    private List<AbstractModule<?>> getModules() {
        List<Object> result = Common.isEmpty(this.packages) ? APIHelper.loadModules(this.desc, ConcreteHelper.getApiPackages()) : APIHelper.loadModules(this.desc, this.packages.toArray(new String[0]));
        Set loaded = result.stream().map(AbstractModule::getInterfaceClass).collect(Collectors.toSet());
        Set noneLoaded = Common.difference(this.classSet, loaded);
        if (!Common.isEmpty((Collection)noneLoaded)) {
            result.addAll(APIHelper.loadModules(this.desc, noneLoaded.toArray(new Class[0])));
        }
        return result;
    }

    public static class Builder {
        private final Set<String> packages = new HashSet<String>();
        private final Set<Class<?>> classSet = new HashSet();
        private final Map<String, Object> ext = new HashMap<String, Object>();
        private String desc;
        private String path;

        public Builder addPackages(String ... packages) {
            if (packages != null && packages.length > 0) {
                this.packages.addAll(Arrays.asList(packages));
            }
            return this;
        }

        public Builder addPackages(Package ... packages) {
            if (packages != null && packages.length > 0) {
                this.packages.addAll(Arrays.stream(packages).map(Package::getName).collect(Collectors.toSet()));
            }
            return this;
        }

        public Builder addClasses(Class<?> ... classes) {
            if (classes != null && classes.length > 0) {
                this.classSet.addAll(Arrays.asList(classes));
            }
            return this;
        }

        public Builder desc(String desc) {
            this.desc = desc;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder ext(Map<String, Object> map) {
            if (map != null && !map.isEmpty()) {
                this.ext.putAll(map);
            }
            return this;
        }

        public Builder module(String module) {
            return this.desc(Config.get((String)"desc", (String[])new String[]{API.TAG_API_GENERATOR, module})).path(Config.get((String)"path", (String[])new String[]{API.TAG_API_GENERATOR, module})).ext(API.toMap(Config.get((String)"ext", (String[])new String[]{API.TAG_API_GENERATOR, module})));
        }

        public API build() {
            return new API(this);
        }
    }
}

