/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools.jaxrs;

import java.util.StringJoiner;
import org.coodex.concrete.common.modules.AbstractModule;
import org.coodex.concrete.common.modules.Documentable;
import org.coodex.concrete.jaxrs.struct.JaxrsParam;
import org.coodex.concrete.jaxrs.struct.JaxrsUnit;
import org.coodex.util.Common;

public class JaxrsRenderHelper {
    public static String getBody(JaxrsUnit unit) {
        JaxrsParam[] pojoParams = unit.getPojo();
        if (pojoParams.length == 0) {
            return null;
        }
        if (pojoParams.length == 1 && !pojoParams[0].isAssembled()) {
            return pojoParams[0].getName();
        }
        StringJoiner joiner = new StringJoiner(", ");
        for (JaxrsParam pojoParam : pojoParams) {
            joiner.add(pojoParam.getName());
        }
        return "{ " + joiner + " }";
    }

    private static String getDesc(Documentable documentable) {
        StringBuilder builder = new StringBuilder();
        String name = documentable.getLabel();
        String desc = documentable.getDescription();
        if (!Common.isBlank((String)name)) {
            builder.append(name);
        }
        if (!Common.isBlank((String)desc)) {
            if (!Common.isBlank((String)name)) {
                builder.append(" - ");
            }
            builder.append(desc);
        }
        return builder.toString();
    }

    public static String getDoc(JaxrsUnit unit) {
        StringBuilder builder = new StringBuilder("    /**\n");
        builder.append("     * ").append(JaxrsRenderHelper.getDesc((Documentable)unit)).append("\n");
        for (JaxrsParam param : (JaxrsParam[])unit.getParameters()) {
            builder.append("     * @param {*} ").append(param.getName()).append(" ").append(JaxrsRenderHelper.getDesc((Documentable)param)).append('\n');
        }
        builder.append("     * @returns Promise \n");
        builder.append("     */");
        return builder.toString();
    }

    public static String getMethodPath(AbstractModule<JaxrsUnit> module, JaxrsUnit unit) {
        return (module.getName() + unit.getName()).replace("{", "${");
    }
}

