/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools.jaxrs.service;

import java.io.IOException;
import java.util.List;
import org.coodex.concrete.apitools.jaxrs.DocToolkit;
import org.coodex.concrete.apitools.jaxrs.service.AbstractServiceDocRenderer;
import org.coodex.concrete.apitools.jaxrs.service.ServiceDocToolkit;
import org.coodex.concrete.common.ErrorMessageFacade;
import org.coodex.concrete.jaxrs.struct.JaxrsModule;

public class ServiceDocRenderer
extends AbstractServiceDocRenderer {
    public static final String RENDER_NAME = "JaxRS.doc.backend.gitbook.v1";
    private static final String RESOURCE_PACKAGE = "concrete/templates/jaxrs/services/doc/gitbook/v1/";
    private DocToolkit toolkit;

    @Override
    protected DocToolkit getToolkit() {
        return this.toolkit;
    }

    @Override
    protected String getTemplatePath() {
        return RESOURCE_PACKAGE;
    }

    @Override
    protected String getRenderName() {
        return RENDER_NAME;
    }

    private void writeSummary(List<JaxrsModule> modules) throws IOException {
        this.writeTo("SUMMARY.md", "SUMMARY.md", "modules", modules, this.toolkit);
    }

    public void writeTo(List<JaxrsModule> modules) throws IOException {
        if (!this.exists("book.json")) {
            this.copyTo("book.json", "book.json");
        }
        if (!this.exists("README.md")) {
            this.copyTo("README.md", "README.md");
        }
        this.writeModuleList(modules);
        for (JaxrsModule module : modules) {
            this.writeModule(module);
        }
        this.writeSummary(modules);
    }

    @Override
    public void render(List<JaxrsModule> modules) throws IOException {
        this.toolkit = new ServiceDocToolkit(this);
        this.writeTo(modules);
        this.writeErrorInfo(ErrorMessageFacade.getAllErrorInfo());
    }
}

