/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools.jaxrs.axios;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.coodex.concrete.api.Description;
import org.coodex.concrete.apitools.AbstractRenderer;
import org.coodex.concrete.apitools.jaxrs.EnumElementInfo;
import org.coodex.concrete.apitools.jaxrs.JaxrsRenderHelper;
import org.coodex.concrete.apitools.jaxrs.axios.TsDefineHelper;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.modules.AbstractModule;
import org.coodex.concrete.common.modules.AbstractUnit;
import org.coodex.concrete.jaxrs.struct.JaxrsModule;
import org.coodex.concrete.jaxrs.struct.JaxrsParam;
import org.coodex.concrete.jaxrs.struct.JaxrsUnit;
import org.coodex.concrete.own.OwnServiceUnit;
import org.coodex.util.Common;
import org.coodex.util.PojoInfo;

public class AxiosCodeRenderer
extends AbstractRenderer<JaxrsModule> {
    public static final String RENDER_NAME = "JaxRS.code.axios.js.v1";
    private static final String RESOURCE_PACKAGE = "concrete/templates/jaxrs/axios/code/v1/";
    private boolean constUtilExist = false;

    @Override
    protected String getTemplatePath() {
        return RESOURCE_PACKAGE;
    }

    @Override
    protected String getRenderName() {
        return RENDER_NAME;
    }

    private void processEnum(JaxrsUnit unit, Set<Type> processed) {
        this.processEnum(unit.getGenericReturnType(), processed);
        for (JaxrsParam param : (JaxrsParam[])unit.getParameters()) {
            this.processEnum(param.getGenericType(), processed);
        }
    }

    private void processEnum(Type t, Set<Type> processed) {
        if (processed.contains(t)) {
            return;
        }
        processed.add(t);
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            this.processEnum(pt.getRawType(), processed);
            for (Type type : pt.getActualTypeArguments()) {
                this.processEnum(type, processed);
            }
        } else if (!(t instanceof TypeVariable)) {
            if (t instanceof GenericArrayType) {
                this.processEnum(((GenericArrayType)t).getGenericComponentType(), processed);
            } else if (t instanceof Class) {
                Class c = (Class)t;
                if (c.isArray()) {
                    this.processEnum(c.getComponentType(), processed);
                } else {
                    if (c.isEnum()) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("elements", EnumElementInfo.of((Class)Common.cast((Object)c)));
                        try {
                            this.writeTo("jaxrs/constants/" + c.getName() + ".js", "enumerable.ftl", map);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        map.put("enumTypeName", c.getSimpleName());
                        map.put("valueType", TsDefineHelper.getTypeScriptValueType((Class)Common.cast((Object)c)));
                        try {
                            this.writeTo("jaxrs/constants/" + c.getName() + ".d.ts", "enumerable.d.ts.ftl", map);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (!ConcreteHelper.isPrimitive((Class)c) && !c.getPackage().getName().startsWith("java")) {
                        PojoInfo pojoInfo = new PojoInfo((Type)c);
                        pojoInfo.getProperties().forEach(pojoProperty -> this.processEnum(pojoProperty.getType(), processed));
                    }
                }
            }
        }
    }

    private void processEnum(JaxrsModule module, Set<Type> processed) throws IOException {
        if (!this.constUtilExist) {
            this.copyTo("EnumBase.d.ts.ftl", "jaxrs/constants/EnumBase.d.ts");
            this.writeTo("jaxrs/constants/constUtil.js", "const allValues = c => {\n    var a = []\n    for (var k in c) {\n        if (typeof c[k] === 'function') continue\n        a.push(c[k])\n    }\n    return a\n}\n\nexport function valueOf(c, value) {\n    for (var k in c) {\n        if (typeof c[k] === 'function') continue\n        if (c[k] === value) {\n            return {\n                key: k,\n                value: c[k],\n            }\n        }\n    }\n    return null\n}\n\nexport function toArray(c, values) {\n    var result = []\n    if (!values) values = allValues(c)\n    for (var i = 0, l = values.length; i < l; i++) {\n        var v = valueOf(c, values[i])\n        if (v) result.push(v)\n    }\n    return result\n}");
            this.constUtilExist = true;
        }
        for (JaxrsUnit unit : (JaxrsUnit[])module.getUnits()) {
            this.processEnum(unit, processed);
        }
    }

    @Override
    public void render(List<JaxrsModule> modules) throws IOException {
        this.constUtilExist = false;
        String moduleName = this.getModuleName();
        HashMap<String, Object> versionAndStyle = new HashMap<String, Object>();
        versionAndStyle.put("version", "0.6.1");
        this.writeTo("jaxrs/concrete.js", "concrete.ftl", versionAndStyle);
        this.copyTo("concrete.d.ts.ftl", "jaxrs/concrete.d.ts");
        HashSet<Type> processed = new HashSet<Type>();
        for (JaxrsModule module : modules) {
            this.processEnum(module, processed);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("moduleName", moduleName);
            param.put("serviceName", module.getInterfaceClass().getSimpleName());
            HashMap<String, HashMap<String, String>> methods = new HashMap<String, HashMap<String, String>>();
            for (JaxrsUnit unit : (JaxrsUnit[])module.getUnits()) {
                String methodName = unit.getMethod().getName();
                HashMap<String, String> method = (HashMap<String, String>)methods.get(methodName);
                if (method == null) {
                    method = new HashMap<String, String>();
                    method.put("name", methodName);
                    method.put("serviceId", OwnServiceUnit.getUnitKey((AbstractUnit)unit));
                    methods.put(methodName, method);
                }
                method.put("jsdoc", JaxrsRenderHelper.getDoc(unit));
                ArrayList overloads = (ArrayList)Common.cast(method.get("overloads"));
                if (overloads == null) {
                    overloads = new ArrayList();
                    method.put("overloads", (String)((Object)overloads));
                }
                HashMap<String, Object> overload = new HashMap<String, Object>();
                overloads.add(overload);
                ArrayList<String> params = new ArrayList<String>();
                for (JaxrsParam p : (JaxrsParam[])unit.getParameters()) {
                    params.add(p.getName());
                }
                overload.put("paramCount", ((JaxrsParam[])unit.getParameters()).length);
                overload.put("params", params);
                overload.put("body", JaxrsRenderHelper.getBody(unit));
                overload.put("url", JaxrsRenderHelper.getMethodPath((AbstractModule<JaxrsUnit>)module, unit));
                overload.put("resultType", String.class.equals((Object)unit.getReturnType()) ? "text" : "json");
                overload.put("httpMethod", unit.getInvokeType());
                if (overloads.size() <= 1) continue;
                param.put("overloadUsed", true);
            }
            param.put("methods", methods.values());
            this.writeTo("jaxrs/" + moduleName + "/" + module.getInterfaceClass().getName() + ".js", "service.ftl", param);
            this.genDTS(module);
        }
    }

    private String getModuleName() {
        String moduleName = this.getRenderDesc().substring(RENDER_NAME.length());
        moduleName = Common.isBlank((String)moduleName) ? "concrete" : moduleName.substring(1);
        return moduleName;
    }

    private void genDTS(JaxrsModule module) throws IOException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("serviceName", module.getInterfaceClass().getSimpleName());
        ArrayList<TsDefineHelper.TsType> allTypes = new ArrayList<TsDefineHelper.TsType>();
        Class contextClass = module.getInterfaceClass();
        Function<Type, TsDefineHelper.TsType> to = t -> {
            TsDefineHelper.TsType resultType = TsDefineHelper.javaToTs(t, contextClass);
            allTypes.add(resultType);
            return resultType;
        };
        ArrayList methods = new ArrayList();
        for (JaxrsUnit unit : (JaxrsUnit[])module.getUnits()) {
            ArrayList<String> methodSign = new ArrayList<String>();
            HashMap<String, Serializable> method = new HashMap<String, Serializable>();
            ArrayList<String> lines = new ArrayList<String>();
            Optional.ofNullable((Description)unit.getDeclaredAnnotation(Description.class)).ifPresent(desc -> {
                lines.add(" * " + desc.name());
                if (Common.isBlank((String)desc.description())) {
                    return;
                }
                lines.add(" * " + desc.description());
            });
            HashSet enumSee = new HashSet();
            Consumer<Class<Enum<?>>> consumer = c -> enumSee.add(c.getName());
            TsDefineHelper.ifEnum(unit.getGenericReturnType(), consumer);
            for (JaxrsParam p : (JaxrsParam[])unit.getParameters()) {
                lines.add(" * @param " + p.getName() + " " + p.getLabel() + " " + p.getDescription());
                methodSign.add(p.getName() + "?: " + to.apply(p.getGenericType()).toText());
                TsDefineHelper.ifEnum(p.getGenericType(), consumer);
            }
            Optional.ofNullable((Deprecated)unit.getDeclaredAnnotation(Deprecated.class)).ifPresent(d -> lines.add(" * @deprecated"));
            StringBuilder methodDTS = new StringBuilder(unit.getMethod().getName()).append("(").append(String.join((CharSequence)", ", methodSign)).append("): Promise<").append(to.apply(unit.getGenericReturnType()).toText()).append(">;");
            enumSee.stream().sorted().forEach(s -> lines.add(" * @see " + s));
            if (!lines.isEmpty()) {
                lines.add(0, "/**");
                lines.add(" */");
            }
            method.put("lines", lines);
            method.put("def", methodDTS);
            methods.add(method);
        }
        param.put("methods", methods);
        param.put("declaredTypes", TsDefineHelper.toTypeScriptDef(allTypes));
        this.writeTo("jaxrs/" + this.getModuleName() + "/" + module.getInterfaceClass().getName() + ".d.ts", "service.d.ts.ftl", param);
    }
}

