/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools.jaxrs.axios;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.coodex.closure.StackClosureContext;
import org.coodex.concrete.api.Description;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;
import org.coodex.util.PojoInfo;
import org.coodex.util.PojoProperty;
import org.coodex.util.Singleton;
import org.coodex.util.Valuable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsDefineHelper {
    private static final Logger log = LoggerFactory.getLogger(TsDefineHelper.class);
    private static final Type[] INTEGER_NUMBER = new Type[]{Integer.TYPE, Integer.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Long.class, Long.TYPE};
    private static final Type[] FLOAT_NUMBER = new Type[]{Float.TYPE, Float.class, Double.TYPE, Double.class};
    private static final Type[] STRING = new Type[]{Character.TYPE, Character.class, String.class};
    private static final Type[] BOOLEAN = new Type[]{Boolean.TYPE, Boolean.class};
    private static final Map<Type, TsType> CACHE = new HashMap<Type, TsType>();
    private static final Map<String, TsType> EMPTY_MAP = (Map)Common.cast((Object)Collections.EMPTY_MAP);
    private static final StackClosureContext<Type> stackClosureContext = new StackClosureContext();
    private static final String BOOL_NAME = "boolean";
    private static final String STRING_NAME = "string";
    private static final String INTEGER_NAME = "Int";
    private static final String FLOAT_NAME = "Float";
    private static final String ANY_NAME = "any";
    private static final String VOID_NAME = "void";
    private static final String[] TS_PRIMITIVE_TYPES = new String[]{"boolean", "string", "any", "void", "Int", "Float"};
    private static final StackClosureContext<String> dependenciesContext = new StackClosureContext();

    @Deprecated
    private static boolean isEnum(Type t) {
        return TsDefineHelper.toEnum(t) != null;
    }

    private static Class<Enum<?>> toEnum(Type t) {
        Class rowClz;
        ParameterizedType pt;
        Type rowType;
        if (t instanceof Class) {
            Class c = (Class)t;
            if (c.isEnum()) {
                return (Class)Common.cast((Object)c);
            }
            if (c.isArray()) {
                return TsDefineHelper.toEnum(c.getComponentType());
            }
            return null;
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)t;
            return TsDefineHelper.toEnum(gat.getGenericComponentType());
        }
        if (t instanceof ParameterizedType && (rowType = (pt = (ParameterizedType)t).getRawType()) instanceof Class && Collection.class.isAssignableFrom(rowClz = (Class)rowType)) {
            return TsDefineHelper.toEnum(GenericTypeHelper.solveFromType(Collection.class.getTypeParameters()[0], (Type)t));
        }
        return null;
    }

    public static void ifEnum(Type t, Consumer<Class<Enum<?>>> consumer) {
        Optional.ofNullable(TsDefineHelper.toEnum(t)).ifPresent(consumer);
    }

    public static String getTypeScriptValueType(Class<Enum<?>> enumClass) {
        if (Valuable.class.isAssignableFrom(enumClass)) {
            Type t = GenericTypeHelper.solveFromType(Valuable.class.getTypeParameters()[0], enumClass);
            if (Common.inArray((Object)t, (Object[])STRING)) {
                return STRING_NAME;
            }
            if (Common.inArray((Object)t, (Object[])INTEGER_NUMBER)) {
                return INTEGER_NAME;
            }
            if (Common.inArray((Object)t, (Object[])FLOAT_NUMBER)) {
                return FLOAT_NAME;
            }
            if (Common.inArray((Object)t, (Object[])BOOLEAN)) {
                return BOOL_NAME;
            }
            throw new RuntimeException("nonsupport type: " + t);
        }
        return STRING_NAME;
    }

    private static TsType contextRunnable(Type t, Type ... context) {
        if (CACHE.containsKey(t)) {
            return CACHE.get(t);
        }
        if (stackClosureContext.contains((Object)t)) {
            return new TsTypeRef(t, context);
        }
        TsType tsType = (TsType)Common.cast((Object)stackClosureContext.call((Object)t, () -> {
            if (t instanceof Class) {
                return TsClass.of((Class)t);
            }
            if (t instanceof ParameterizedType) {
                return TsParameterizedType.of((ParameterizedType)t, new Type[0]);
            }
            if (t instanceof GenericArrayType) {
                return TsParameterizedType.of((GenericArrayType)t, new Type[0]);
            }
            if (t instanceof TypeVariable) {
                return new TsTypeVariable(((TypeVariable)t).getName());
            }
            throw new RuntimeException("unsupported type: " + t);
        }));
        CACHE.put(t, tsType);
        return tsType;
    }

    public static TsType javaToTs(Type t, Type ... context) {
        return TsDefineHelper.contextRunnable(t, context);
    }

    public static String toTypeScriptDef(List<TsType> tsTypes) {
        HashMap<String, TsType> tsTypeMap = new HashMap<String, TsType>();
        tsTypes.forEach(type -> {
            if (type.isDefinable()) {
                tsTypeMap.putIfAbsent(type.getName(), (TsType)type);
            }
            tsTypeMap.putAll(type.getDependencies());
        });
        TsNameSpace root = new TsNameSpace(null);
        tsTypeMap.forEach((k, v) -> {
            if (!v.isDefinable()) {
                return;
            }
            String[] nodes = k.split("\\.");
            TsNameSpace x = root;
            int l = nodes.length - 1;
            for (int i = 0; i < l; ++i) {
                x = x.get(nodes[i]);
            }
            x.tsTypes.add(v);
        });
        List simplified = root.simplify();
        StringBuilder builder = new StringBuilder();
        simplified.forEach(ns -> builder.append(ns.toDTS(((TsNameSpace)ns).name == null ? null : "", ((TsNameSpace)ns).name != null)));
        return builder.toString();
    }

    public static interface TsType {
        public String getName();

        public String toText();

        public boolean isDefinable();

        default public boolean isPrimitive() {
            return Common.inArray((Object)this.getName(), (Object[])TS_PRIMITIVE_TYPES);
        }

        default public Map<String, TsType> getDependencies() {
            return EMPTY_MAP;
        }

        default public String toDTS(String intend, boolean declare) {
            return null;
        }
    }

    public static class TsTypeRef
    implements TsType {
        private final Singleton<TsType> supplier = Singleton.with(() -> TsDefineHelper.javaToTs(type, context));

        public TsTypeRef(Type type, Type[] context) {
        }

        public TsType getActualType() {
            return (TsType)this.supplier.get();
        }

        @Override
        public String getName() {
            return ((TsType)this.supplier.get()).getName();
        }

        @Override
        public String toText() {
            return ((TsType)this.supplier.get()).toText();
        }

        @Override
        public boolean isDefinable() {
            return ((TsType)this.supplier.get()).isDefinable();
        }

        @Override
        public Map<String, TsType> getDependencies() {
            return ((TsType)this.supplier.get()).getDependencies();
        }
    }

    static class TsNameSpace {
        private final List<TsType> tsTypes = new ArrayList<TsType>();
        private final List<TsNameSpace> nameSpaces = new ArrayList<TsNameSpace>();
        private String name;

        TsNameSpace(String name) {
            this.name = name;
        }

        private boolean isBlank() {
            return this.tsTypes.isEmpty();
        }

        private String nextIntend(String indent) {
            return indent == null ? "" : indent + (this.isBlank() ? "" : "\t");
        }

        private List<TsNameSpace> simplify() {
            if (this.isBlank()) {
                ArrayList<TsNameSpace> simplifiedNameSpace = new ArrayList<TsNameSpace>();
                this.nameSpaces.forEach(n -> simplifiedNameSpace.addAll(n.simplify()));
                if (this.name != null) {
                    simplifiedNameSpace.forEach(n -> {
                        n.name = this.name + "." + n.name;
                    });
                }
                return simplifiedNameSpace;
            }
            return Collections.singletonList(this);
        }

        public String getName() {
            return this.name;
        }

        public TsNameSpace get(String sub) {
            return this.nameSpaces.stream().filter(n -> Objects.equals(n.name, sub)).findFirst().orElseGet(() -> {
                TsNameSpace tsNameSpace = new TsNameSpace(sub);
                this.nameSpaces.add(tsNameSpace);
                return tsNameSpace;
            });
        }

        public String toDTS(String indent, boolean declare) {
            boolean root = Common.isBlank((String)this.name);
            String _indent = indent == null ? "" : indent;
            String nextIndent = this.nextIntend(indent);
            StringBuilder builder = new StringBuilder(_indent);
            if (!root) {
                builder.append(declare ? "declare " : "").append("namespace ").append(this.name).append(" {\n");
            }
            this.nameSpaces.stream().sorted(Comparator.comparing(TsNameSpace::getName)).forEach(n -> builder.append(n.toDTS(nextIndent, root)));
            this.tsTypes.stream().sorted(Comparator.comparing(TsType::getName)).forEach(t -> {
                if (!(t instanceof TsClass)) {
                    throw new RuntimeException("???:" + t);
                }
                TsClass tsClass = (TsClass)t;
                builder.append(tsClass.toDTS(nextIndent, Common.isBlank((String)this.name))).append("\n");
            });
            if (!root) {
                builder.append(_indent).append("}\n");
            }
            return builder.toString();
        }

        public String toString() {
            return "TsNameSpace{tsTypes=" + this.tsTypes + ", name='" + this.name + '\'' + ", nameSpaces=" + this.nameSpaces + '}';
        }
    }

    public static class TsClass
    implements TsType {
        public static TsClass BOOL = new TsClass("boolean", false, null);
        public static TsClass FLOAT = new TsClass("Float", false, null);
        public static TsClass INT = new TsClass("Int", false, null);
        public static TsClass STRING = new TsClass("string", false, null);
        public static TsClass ANY = new TsClass("any", false, null);
        public static TsClass VOID = new TsClass("void", false, null);
        private final Set<TsField> fields = new HashSet<TsField>();
        private final List<TsType> typeParameters = new ArrayList<TsType>();
        private final String name;
        private final boolean array;
        private final TsType componentClass;
        private String namespace;
        private boolean def = false;

        public TsClass(String name, boolean array, TsType componentClass) {
            this.name = name;
            this.array = array;
            this.componentClass = componentClass;
        }

        public static TsType of(Class<?> c) {
            if (c.isArray()) {
                return new TsClass("", true, TsClass.of(c.getComponentType()));
            }
            if (Common.inArray(c, (Object[])FLOAT_NUMBER)) {
                return FLOAT;
            }
            if (Common.inArray(c, (Object[])INTEGER_NUMBER)) {
                return INT;
            }
            if (Common.inArray(c, (Object[])BOOLEAN)) {
                return BOOL;
            }
            if (Common.inArray(c, (Object[])STRING)) {
                return STRING;
            }
            if (c.isEnum()) {
                return new TsClass(TsDefineHelper.getTypeScriptValueType((Class)Common.cast(c)), false, null);
            }
            if (Void.class.equals(c) || Void.TYPE.equals(c)) {
                return VOID;
            }
            if (c.getPackage().getName().startsWith("java.")) {
                log.warn("unsupported type: {}. use `any`", c);
                return ANY;
            }
            TsClass tsClass = new TsClass(c.getTypeName().substring(c.getPackage().getName().length() + 1), false, null);
            tsClass.namespace = c.getPackage().getName();
            tsClass.def = true;
            Arrays.stream(c.getTypeParameters()).forEach(t -> tsClass.typeParameters.add(TsDefineHelper.javaToTs(t, new Type[0])));
            PojoInfo pojoInfo = new PojoInfo(c);
            for (PojoProperty property : pojoInfo.getProperties()) {
                tsClass.fields.add(new TsField(property, c));
            }
            return tsClass;
        }

        @Override
        public String getName() {
            return (Common.isBlank((String)this.namespace) ? "" : this.namespace + ".") + this.name;
        }

        public String getSimpleName() {
            return this.name;
        }

        @Override
        public String toText() {
            String text;
            String string = text = this.array ? this.componentClass.toText() : this.getName();
            if (!this.typeParameters.isEmpty()) {
                text = text + "<" + this.typeParameters.stream().map(TsType::toText).collect(Collectors.joining(", ")) + ">";
            }
            if (this.array) {
                text = text + "[]";
            }
            return text;
        }

        @Override
        public boolean isDefinable() {
            return !this.array && this.def;
        }

        @Override
        public Map<String, TsType> getDependencies() {
            if (this.array) {
                return this.componentClass.getDependencies();
            }
            if (dependenciesContext.contains((Object)this.toText())) {
                return EMPTY_MAP;
            }
            return (Map)Common.cast((Object)dependenciesContext.call((Object)this.toText(), () -> {
                HashMap<String, TsClass> map = new HashMap<String, TsClass>();
                map.put(this.toText(), this);
                this.fields.forEach(f -> {
                    if (f.getType() instanceof TsTypeVariable) {
                        return;
                    }
                    String label = f.getType().getName();
                    if (dependenciesContext.contains((Object)label)) {
                        return;
                    }
                    TsType type = f.getType();
                    while (type instanceof TsTypeRef) {
                        type = ((TsTypeRef)type).getActualType();
                    }
                    if (!type.isPrimitive() && label != null) {
                        map.putIfAbsent(label, (TsClass)type);
                    }
                    map.putAll(type.getDependencies());
                });
                return map;
            }));
        }

        public String toString() {
            return this.toDTS("", true);
        }

        @Override
        public String toDTS(String intend, boolean declare) {
            StringBuilder builder = new StringBuilder(intend).append(declare ? "declare " : "").append("class ").append(this.getSimpleName());
            if (!this.typeParameters.isEmpty()) {
                builder.append("<").append(this.typeParameters.stream().map(TsType::getName).collect(Collectors.joining(","))).append(">");
            }
            builder.append("{");
            this.fields.forEach(field -> {
                ((TsField)field).docLines.forEach(s -> builder.append("\n").append(intend).append("\t").append((String)s));
                builder.append("\n").append(intend).append("\t").append(field.getName()).append("?: ").append(field.getType().toText()).append(";");
            });
            return builder.append("\n").append(intend).append("}").toString();
        }
    }

    public static class TsParameterizedType
    implements TsType {
        private final List<TsType> parameterTypes = new ArrayList<TsType>();
        private TsType rowType;
        private boolean collection = false;
        private TsType componentType;

        public static TsType of(ParameterizedType parameterizedType, Type ... context) {
            TsParameterizedType type = new TsParameterizedType();
            Class rowType = (Class)parameterizedType.getRawType();
            if (Collection.class.isAssignableFrom(rowType)) {
                type.collection = true;
                type.componentType = TsDefineHelper.javaToTs(parameterizedType.getActualTypeArguments()[0], context);
                return type;
            }
            if (rowType.getPackage().getName().startsWith("java.")) {
                log.warn("unsupported type: {}", (Object)parameterizedType);
                return TsClass.ANY;
            }
            type.rowType = TsDefineHelper.javaToTs(rowType, new Type[0]);
            Arrays.stream(parameterizedType.getActualTypeArguments()).forEach(t -> type.parameterTypes.add(TsDefineHelper.javaToTs(t, context)));
            return type;
        }

        public static TsType of(GenericArrayType genericArrayType, Type ... context) {
            TsParameterizedType type = new TsParameterizedType();
            type.collection = true;
            type.componentType = TsDefineHelper.javaToTs(genericArrayType.getGenericComponentType(), context);
            return type;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String toText() {
            try {
                String text;
                String string = text = this.collection ? this.componentType.toText() : this.rowType.getName();
                if (!this.parameterTypes.isEmpty()) {
                    text = text + "<" + this.parameterTypes.stream().map(TsType::toText).collect(Collectors.joining(", ")) + ">";
                }
                if (this.collection) {
                    text = text + "[]";
                }
                return text;
            }
            catch (NullPointerException e) {
                System.out.println(this.collection);
                System.out.println(this.getName());
                System.out.println(this.componentType);
                System.out.println(this.rowType);
                throw e;
            }
        }

        @Override
        public boolean isDefinable() {
            return false;
        }

        @Override
        public Map<String, TsType> getDependencies() {
            if (this.collection) {
                return this.componentType.getDependencies();
            }
            HashMap<String, TsType> tsTypeMap = new HashMap<String, TsType>();
            if (!dependenciesContext.contains((Object)this.rowType.toText())) {
                tsTypeMap.putIfAbsent(this.rowType.toText(), this.rowType);
                tsTypeMap.putAll(this.rowType.getDependencies());
            }
            this.parameterTypes.forEach(t -> tsTypeMap.putAll(t.getDependencies()));
            return tsTypeMap;
        }
    }

    public static class TsTypeVariable
    implements TsType {
        private final String name;

        public TsTypeVariable(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String toText() {
            return this.name;
        }

        @Override
        public boolean isDefinable() {
            return false;
        }
    }

    public static class TsField {
        private final String name;
        private final TsType type;
        private final List<String> docLines = new ArrayList<String>();

        public TsField(PojoProperty property, Type c) {
            this.name = property.getName();
            this.type = TsDefineHelper.javaToTs(property.getType(), c);
            ArrayList lines = new ArrayList();
            Optional.ofNullable((Description)property.getAnnotation(Description.class)).ifPresent(desc -> {
                lines.add(" * " + desc.name());
                if (Common.isBlank((String)desc.description())) {
                    return;
                }
                Arrays.stream(desc.description().split("\n")).forEach(s -> lines.add(" * " + s));
            });
            Optional.ofNullable((Deprecated)property.getAnnotation(Deprecated.class)).ifPresent(deprecated -> lines.add(" * @deprecated "));
            TsDefineHelper.ifEnum(property.getType(), e -> lines.add(" * @see " + e.getName()));
            if (!lines.isEmpty()) {
                this.docLines.add("/**");
                this.docLines.addAll(lines);
                this.docLines.add(" */");
            }
        }

        @Deprecated
        public TsField(String name, TsType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public TsType getType() {
            return this.type;
        }
    }
}

