/*
 * Copyright (c) 2018 coodex.org (jujus.shen@126.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.coodex.concrete.api;

import org.coodex.concrete.common.SignatureSerializer;

import java.lang.annotation.*;

/**
 * Created by davidoff shen on 2017-04-20.
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Overlay
public @interface Signable {

    String paperName() default "";

    //    Class<? extends IronPenFactory> ironPenFactory() default IronPenFactory.class;
    String algorithm() default "SHA256withRSA";

    Class<? extends SignatureSerializer> serializer() default SignatureSerializer.class;
}
