/*
 * Copyright (c) 2018 coodex.org (jujus.shen@126.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.coodex.concrete.api.pojo;

import org.coodex.concrete.api.Description;
import org.coodex.mock.Mock;

/**
 * Created by davidoff shen on 2017-03-21.
 */
public abstract class AbstractPage {
    @Description(name = "第几页", description = "从1开始")
    @Mock.Inject("pageNum")
    private Long num;
    @Description(name = "每页多少条数据")
    @Mock.Inject("pageSize")
    private Integer pageSize;


    public Long getNum() {
        return num;
    }

    public void setNum(Long num) {
        this.num = num;
    }


    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}
