/*
 * Copyright (c) 2018 coodex.org (jujus.shen@126.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.coodex.concrete.common;

/**
 * 名称源自《国家宝藏1》
 * <p>
 * Created by davidoff shen on 2017-04-20.
 */
public interface IronPen {

    /**
     * 签名
     *
     * @param content   content
     * @param algorithm algorithm
     * @param keyId     keyId
     * @return 签名
     */
    byte[] sign(byte[] content, String algorithm, String keyId);


    /**
     * 验签
     *
     * @param content   content
     * @param signature signature
     * @param algorithm algorithm
     * @param keyId     keyId
     * @return 验签是否正确
     */
    boolean verify(byte[] content, byte[] signature, String algorithm, String keyId);
}
