/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.api.rx;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.coodex.concrete.api.ConcreteService;
import org.coodex.concrete.api.rx.CompletableCodeBuilder;
import org.coodex.concrete.api.rx.ReactiveExtensionFor;
import org.coodex.concrete.api.rx.RxCodeBuilder;
import org.coodex.util.Common;
import org.coodex.util.SingletonMap;

@SupportedAnnotationTypes(value={"org.coodex.concrete.api.ConcreteService"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class RxClientAPIProcessor
extends AbstractProcessor {
    private static final String[] PRIMITIVE_TYPES = new String[]{Boolean.TYPE.getName(), Byte.TYPE.getName(), Short.TYPE.getName(), Integer.TYPE.getName(), Long.TYPE.getName(), Character.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName()};
    private static final String[] AUTO_BOXED_TYPES = new String[]{Boolean.class.getName(), Byte.class.getName(), Short.class.getName(), Integer.class.getName(), Long.class.getName(), Character.class.getName(), Float.class.getName(), Double.class.getName()};
    private static final Set<Name> processedClasses = new HashSet<Name>();
    private static final SingletonMap<String, RxCodeBuilder> builderSingletonMap = SingletonMap.builder().function(key -> {
        try {
            Class<?> clazz = Class.forName(key);
            return (RxCodeBuilder)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }).build();

    private static String autoBox(PrimitiveType type) {
        return AUTO_BOXED_TYPES[Common.indexOf((Object[])PRIMITIVE_TYPES, (Object)type.toString())];
    }

    private static String getActualType(TypeMirror typeMirror, TypeElement context, Types typesUtil, boolean autoBoxed) {
        DeclaredType containing = (DeclaredType)context.asType();
        if (typeMirror instanceof TypeVariable) {
            return typesUtil.asMemberOf(containing, ((TypeVariable)typeMirror).asElement()).toString();
        }
        if (typeMirror instanceof PrimitiveType) {
            return autoBoxed ? RxClientAPIProcessor.autoBox((PrimitiveType)typeMirror) : typeMirror.toString();
        }
        if (typeMirror instanceof ArrayType) {
            return RxClientAPIProcessor.getActualType(((ArrayType)typeMirror).getComponentType(), context, typesUtil, false) + "[]";
        }
        if (typeMirror instanceof NoType) {
            return Void.class.getName();
        }
        if (typeMirror instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            if (declaredType.getTypeArguments().size() > 0) {
                StringBuilder builder = new StringBuilder(declaredType.asElement().toString());
                builder.append("<");
                int i = 0;
                for (TypeMirror typeMirror2 : declaredType.getTypeArguments()) {
                    if (i++ > 0) {
                        builder.append(", ");
                    }
                    builder.append(RxClientAPIProcessor.getActualType(typeMirror2, context, typesUtil, false));
                }
                builder.append(">");
                return builder.toString();
            }
            return declaredType.toString();
        }
        return null;
    }

    private static RxCodeBuilder getRxCodeBuilder(String rxType) {
        return (RxCodeBuilder)builderSingletonMap.get((Object)rxType);
    }

    private static Set<String> getBuilders() {
        HashSet<String> result = new HashSet<String>();
        result.add(CompletableCodeBuilder.class.getName());
        try {
            Enumeration<URL> urlEnumeration = RxClientAPIProcessor.class.getClassLoader().getResources("META-INF/services/org.coodex.concrete.api.rx.RxCodeBuilder");
            while (urlEnumeration.hasMoreElements()) {
                URL url = urlEnumeration.nextElement();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String className = line.trim();
                        if (Common.isBlank((String)className) || className.startsWith("#")) continue;
                        result.add(className);
                    }
                }
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Types typesUtil = this.processingEnv.getTypeUtils();
        Elements elementsUtil = this.processingEnv.getElementUtils();
        TypeMirror objectType = elementsUtil.getTypeElement(Object.class.getName()).asType();
        for (Element element : roundEnv.getElementsAnnotatedWith(ConcreteService.class)) {
            ConcreteService serviceAnnotation;
            TypeElement serviceType;
            if (!(element instanceof TypeElement) || !((serviceType = (TypeElement)element).asType() instanceof DeclaredType) || (serviceAnnotation = element.getAnnotation(ConcreteService.class)).nonspecific() || serviceAnnotation.notService() || processedClasses.contains(serviceType.getQualifiedName())) continue;
            PackageElement packageElement = elementsUtil.getPackageOf(serviceType);
            for (String rxType : RxClientAPIProcessor.getBuilders()) {
                RxCodeBuilder builder = RxClientAPIProcessor.getRxCodeBuilder(rxType);
                if (builder == null) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "no code builder for: " + rxType, serviceType);
                    continue;
                }
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "build " + rxType + " interface.");
                StringBuilder codeBuilder = new StringBuilder();
                String packageName = packageElement.isUnnamed() ? null : packageElement.toString();
                codeBuilder.append(packageName == null ? "" : "package " + packageName + ";").append("\n\n").append("@").append(ReactiveExtensionFor.class.getName()).append("(").append(serviceType.getQualifiedName()).append(".class)\n").append("public interface ").append(builder.getAdj()).append(serviceType.getSimpleName()).append("{\n");
                elementsUtil.getAllMembers(serviceType).forEach(memberElement -> {
                    if (!(memberElement instanceof ExecutableElement)) {
                        return;
                    }
                    ExecutableElement e = (ExecutableElement)memberElement;
                    if (e.getEnclosingElement().asType().equals(objectType)) {
                        return;
                    }
                    codeBuilder.append("\t").append(builder.getReturnTypeCode(RxClientAPIProcessor.getActualType(e.getReturnType(), serviceType, typesUtil, true))).append(" ").append(e.getSimpleName()).append('(');
                    int i = 0;
                    for (VariableElement variableElement : e.getParameters()) {
                        if (i++ != 0) {
                            codeBuilder.append(", ");
                        }
                        codeBuilder.append(RxClientAPIProcessor.getActualType(variableElement.asType(), serviceType, typesUtil, false)).append(" ").append(variableElement.getSimpleName());
                    }
                    codeBuilder.append(");\n\n");
                });
                codeBuilder.append("}");
                String fileName = (packageName == null ? "" : packageName + ".") + builder.getAdj() + serviceType.getSimpleName();
                String code = codeBuilder.toString();
                try {
                    JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(fileName, new Element[0]);
                    try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
                        out.println(code);
                    }
                }
                catch (Throwable th) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "build " + rxType + " interface failed: " + th.getLocalizedMessage() + "\n\n" + code);
                }
            }
            processedClasses.add(serviceType.getQualifiedName());
        }
        return false;
    }
}

