/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apm.mysql8;

import com.mysql.cj.MysqlConnection;
import com.mysql.cj.Query;
import com.mysql.cj.interceptors.QueryInterceptor;
import com.mysql.cj.log.Log;
import com.mysql.cj.protocol.Resultset;
import com.mysql.cj.protocol.ServerSession;
import java.util.Properties;
import java.util.function.Supplier;
import org.coodex.concrete.apm.APM;
import org.coodex.concrete.apm.Trace;
import org.coodex.concrete.apm.mysql8.TracingExceptionInterceptor;

public class TracingQueryInterceptor
implements QueryInterceptor {
    static ThreadLocal<Trace> traceThreadLocal = new ThreadLocal();
    private MysqlConnection connection;
    private boolean interceptingExceptions;

    public <T extends Resultset> T preProcess(Supplier<String> sqlSupplier, Query interceptedQuery) {
        Trace trace = APM.build();
        traceThreadLocal.set(trace);
        String sql = sqlSupplier.get();
        int spaceIndex = sql.indexOf(32);
        trace.tag("sql.query", sql).start(spaceIndex == -1 ? sql : sql.substring(0, spaceIndex));
        return null;
    }

    public <T extends Resultset> T postProcess(Supplier<String> sql, Query interceptedQuery, T originalResultSet, ServerSession serverSession) {
        Trace trace = traceThreadLocal.get();
        traceThreadLocal.remove();
        if (trace != null) {
            trace.finish();
        }
        return null;
    }

    public boolean executeTopLevelOnly() {
        return true;
    }

    public QueryInterceptor init(MysqlConnection mysqlConnection, Properties properties, Log log) {
        String exceptionInterceptors = properties.getProperty("exceptionInterceptors");
        TracingQueryInterceptor interceptor = new TracingQueryInterceptor();
        interceptor.connection = mysqlConnection;
        boolean bl = interceptor.interceptingExceptions = exceptionInterceptors != null && exceptionInterceptors.contains(TracingExceptionInterceptor.class.getName());
        if (!interceptor.interceptingExceptions) {
            log.logWarn((Object)"TracingExceptionInterceptor not enabled. It is highly recommended to enable it for error logging to Zipkin.");
        }
        return interceptor;
    }

    public void destroy() {
    }
}

