/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.commons.jpa.criteria;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;

public class Operators {

    public static class CustomPatternLikeOperator
    extends AbstractLikeOperator {
        @Override
        public Logical getLogical() {
            return Logical.CUSTOM_LIKE;
        }

        @Override
        protected String toPattern(String value) {
            return value;
        }
    }

    public static class EndWithOperator
    extends AbstractLikeOperator {
        @Override
        public Logical getLogical() {
            return Logical.END_WITH;
        }

        @Override
        protected String toPattern(String value) {
            return "%" + value;
        }
    }

    public static class EqualOperator
    extends SingleParamOperator {
        @Override
        public Logical getLogical() {
            return Logical.EQUAL;
        }

        @Override
        protected <ATTR> Predicate buildPredicate(Path<ATTR> attrPath, CriteriaBuilder cb, ATTR[] attributes) {
            return cb.equal(attrPath, attributes[0]);
        }
    }

    public static class GreaterEqualOperator
    extends SingleParamOperator {
        @Override
        public Logical getLogical() {
            return Logical.GREATER_EQUAL;
        }

        @Override
        protected <ATTR> Predicate buildPredicate(Path<ATTR> attrPath, CriteriaBuilder cb, ATTR[] attributes) {
            if (attributes[0] instanceof Comparable) {
                return cb.greaterThanOrEqualTo(attrPath, (Comparable)attributes[0]);
            }
            return this.unsupported(attrPath);
        }
    }

    public static class GreaterOperator
    extends SingleParamOperator {
        @Override
        public Logical getLogical() {
            return Logical.GREATER;
        }

        @Override
        protected <ATTR> Predicate buildPredicate(Path<ATTR> attrPath, CriteriaBuilder cb, ATTR[] attributes) {
            if (attributes[0] instanceof Comparable) {
                return cb.greaterThan(attrPath, (Comparable)attributes[0]);
            }
            return this.unsupported(attrPath);
        }
    }

    public static class BetweenOperator
    extends TwoParamOperator {
        @Override
        public Logical getLogical() {
            return Logical.BETWEEN;
        }

        @Override
        protected <ATTR> Predicate buildPredicate(Path<ATTR> attrPath, CriteriaBuilder cb, ATTR[] attributes) {
            if (attributes[0] instanceof Comparable) {
                return cb.between(attrPath, (Comparable)attributes[0], (Comparable)attributes[1]);
            }
            return this.unsupported(attrPath);
        }
    }

    public static class InOperator
    extends MultiParamOperator {
        @Override
        public Logical getLogical() {
            return Logical.IN;
        }

        @Override
        protected <ATTR> Predicate buildPredicate(Path<ATTR> attrPath, CriteriaBuilder cb, ATTR[] attributes) {
            CriteriaBuilder.In predicate = cb.in(attrPath);
            for (ATTR item : attributes) {
                predicate.value(item);
            }
            return predicate;
        }
    }

    public static class IsNullOperator
    extends NoneParamOperator {
        @Override
        public Logical getLogical() {
            return Logical.IS_NULL;
        }

        @Override
        protected <ATTR> Predicate buildPredicate(Path<ATTR> attrPath, CriteriaBuilder cb, ATTR[] attributes) {
            return cb.isNull(attrPath);
        }
    }

    public static class LessEqualOperator
    extends SingleParamOperator {
        @Override
        public Logical getLogical() {
            return Logical.LESS_EQUAL;
        }

        @Override
        protected <ATTR> Predicate buildPredicate(Path<ATTR> attrPath, CriteriaBuilder cb, ATTR[] attributes) {
            if (attributes[0] instanceof Comparable) {
                return cb.lessThanOrEqualTo(attrPath, (Comparable)attributes[0]);
            }
            return this.unsupported(attrPath);
        }
    }

    public static class LessOperator
    extends SingleParamOperator {
        @Override
        public Logical getLogical() {
            return Logical.LESS;
        }

        @Override
        protected <ATTR> Predicate buildPredicate(Path<ATTR> attrPath, CriteriaBuilder cb, ATTR[] attributes) {
            if (attributes[0] instanceof Comparable) {
                return cb.lessThan((Expression)Common.cast(attrPath), (Comparable)attributes[0]);
            }
            return this.unsupported(attrPath);
        }
    }

    public static class LikeOperator
    extends AbstractLikeOperator {
        @Override
        public Logical getLogical() {
            return Logical.LIKE;
        }

        @Override
        protected String toPattern(String value) {
            return "%" + value + "%";
        }
    }

    public static class NotEqualOperator
    extends SingleParamOperator {
        @Override
        public Logical getLogical() {
            return Logical.NOT_EQUAL;
        }

        @Override
        protected <ATTR> Predicate buildPredicate(Path<ATTR> attrPath, CriteriaBuilder cb, ATTR[] attributes) {
            return cb.notEqual(attrPath, attributes[0]);
        }
    }

    public static class NotInOperator
    extends InOperator {
        @Override
        public Logical getLogical() {
            return Logical.NOT_IN;
        }

        @Override
        protected <ATTR> Predicate buildPredicate(Path<ATTR> attrPath, CriteriaBuilder cb, ATTR[] attributes) {
            return cb.not((Expression)super.buildPredicate(attrPath, cb, attributes));
        }
    }

    public static class NotNullOperator
    extends NoneParamOperator {
        @Override
        public Logical getLogical() {
            return Logical.NOT_NULL;
        }

        @Override
        protected <ATTR> Predicate buildPredicate(Path<ATTR> attrPath, CriteriaBuilder cb, ATTR[] attributes) {
            return cb.isNotNull(attrPath);
        }
    }

    public static class StartWithOperator
    extends AbstractLikeOperator {
        @Override
        public Logical getLogical() {
            return Logical.START_WITH;
        }

        @Override
        protected String toPattern(String value) {
            return value + "%";
        }
    }

    static abstract class AbstractLikeOperator
    extends SingleParamOperator {
        AbstractLikeOperator() {
        }

        protected abstract String toPattern(String var1);

        @Override
        protected <ATTR> Predicate buildPredicate(Path<ATTR> attrPath, CriteriaBuilder cb, ATTR[] attributes) {
            if (attributes[0] instanceof String) {
                return cb.like(attrPath, this.toPattern((String)attributes[0]));
            }
            return this.unsupported(attrPath);
        }
    }

    static abstract class TwoParamOperator
    extends AbstractOperator {
        TwoParamOperator() {
        }

        @Override
        protected <ATTR> void check(ATTR[] attributes) {
            if (attributes == null || attributes.length != 2) {
                throw new IllegalArgumentException("must be TWO attribute.");
            }
        }
    }

    static abstract class SingleParamOperator
    extends AbstractOperator {
        SingleParamOperator() {
        }

        @Override
        protected <ATTR> void check(ATTR[] attributes) {
            if (attributes == null || attributes.length != 1) {
                throw new IllegalArgumentException("must be ONE attribute.");
            }
        }
    }

    static abstract class MultiParamOperator
    extends AbstractOperator {
        MultiParamOperator() {
        }

        @Override
        protected <ATTR> void check(ATTR[] attributes) {
            if (attributes == null || attributes.length == 0) {
                throw new IllegalArgumentException("must have ONE attribute AT LEAST.");
            }
        }
    }

    static abstract class NoneParamOperator
    extends AbstractOperator {
        NoneParamOperator() {
        }

        @Override
        protected <ATTR> void check(ATTR[] attributes) {
        }
    }

    static abstract class AbstractOperator
    implements Operator {
        AbstractOperator() {
        }

        protected abstract <ATTR> void check(ATTR[] var1);

        protected abstract <ATTR> Predicate buildPredicate(Path<ATTR> var1, CriteriaBuilder var2, ATTR[] var3);

        <ATTR> Class<ATTR> getAttributeType(Path<ATTR> attrPath) {
            return (Class)Common.cast((Object)GenericTypeHelper.solveFromInstance(Path.class.getTypeParameters()[0], attrPath));
        }

        <ATTR> Predicate unsupported(Path<ATTR> attrPath) {
            throw new IllegalArgumentException("logical " + String.valueOf((Object)this.getLogical()) + " unsupported attribute type: " + String.valueOf(this.getAttributeType(attrPath)));
        }

        @Override
        public <ATTR> Predicate toPredicate(Path<ATTR> attrPath, CriteriaBuilder cb, ATTR[] attributes) {
            this.check(attributes);
            return this.buildPredicate(attrPath, cb, attributes);
        }
    }

    public static interface Operator {
        public Logical getLogical();

        public <ATTR> Predicate toPredicate(Path<ATTR> var1, CriteriaBuilder var2, ATTR[] var3);
    }

    public static enum Logical {
        EQUAL(new EqualOperator()),
        LESS(new LessOperator()),
        GREATER(new GreaterOperator()),
        LESS_EQUAL(new LessEqualOperator()),
        GREATER_EQUAL(new GreaterEqualOperator()),
        NOT_EQUAL(new NotEqualOperator()),
        BETWEEN(new BetweenOperator()),
        IN(new InOperator()),
        NOT_IN(new NotInOperator()),
        LIKE(new LikeOperator()),
        START_WITH(new StartWithOperator()),
        END_WITH(new EndWithOperator()),
        CUSTOM_LIKE(new CustomPatternLikeOperator()),
        IS_NULL(new IsNullOperator()),
        NOT_NULL(new NotNullOperator());

        private final Operator operator;

        private Logical(Operator operator) {
            this.operator = operator;
        }

        public Operator getOperator() {
            return this.operator;
        }
    }
}

