/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.core.intercept.AbstractSyncInterceptor;
import org.coodex.concrete.core.intercept.annotations.ServerSide;
import org.coodex.mock.Mocker;
import org.coodex.util.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerSide
public class MockV2Interceptor
extends AbstractSyncInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MockV2Interceptor.class);
    private final Set<Class<?>> exceptedClasses = new HashSet();
    private final Set<Pattern> patterns = new HashSet<Pattern>();

    public MockV2Interceptor() throws IOException {
        this(new HashSet());
    }

    public MockV2Interceptor(Set<Class<?>> exceptedClasses) throws IOException {
        this.setExceptedClasses(exceptedClasses);
        this.loadExcepted();
    }

    private void loadExcepted() throws IOException {
        URL excepted = Common.getResource((String)"mock.excepted", (ClassLoader[])new ClassLoader[0]);
        if (excepted == null) {
            return;
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(excepted.openStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (Common.isBlank((String)(line = line.trim())) || line.startsWith("#")) continue;
                try {
                    this.exceptedClasses.add(Class.forName(line));
                }
                catch (ClassNotFoundException e) {
                    this.patterns.add(Pattern.compile("^" + line + "$"));
                    log.info("ClassNotFound: {}, use regex", (Object)line);
                }
            }
        }
    }

    protected boolean accept_(DefinitionContext context) {
        boolean notMock = this.exceptedClasses.contains(context.getDeclaringClass());
        if (notMock) {
            return false;
        }
        String className = context.getDeclaringClass().getName();
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(className).matches()) continue;
            return false;
        }
        return true;
    }

    public Set<Class<?>> getExceptedClasses() {
        return this.exceptedClasses;
    }

    public void setExceptedClasses(Set<Class<?>> exceptedClasses) {
        if (exceptedClasses != null && exceptedClasses.size() > 0) {
            this.exceptedClasses.addAll(exceptedClasses);
        }
    }

    public Object around(DefinitionContext context, MethodInvocation joinPoint) {
        return this.run(context);
    }

    private Object run(DefinitionContext context) {
        if (Void.TYPE.equals(context.getDeclaringMethod().getReturnType())) {
            return null;
        }
        return Mocker.mockMethod((Method)context.getDeclaringMethod(), (Type)context.getDeclaringClass());
    }

    public int getOrder() {
        return 9002;
    }
}

