/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.function.Supplier;
import org.coodex.closure.ClosureContext;
import org.coodex.closure.StackClosureContext;
import org.coodex.concrete.client.ClientSideContext;
import org.coodex.concrete.common.BeanServiceLoaderProvider;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.core.intercept.ConcreteInterceptor;
import org.coodex.concrete.core.intercept.ConcreteMethodInvocation;
import org.coodex.concrete.core.intercept.InterceptorChain;
import org.coodex.concrete.core.intercept.SyncInterceptorChain;
import org.coodex.util.Common;
import org.coodex.util.LazyServiceLoader;
import org.coodex.util.Singleton;

public final class ConcreteContext {
    public static final String KEY_TOKEN = "CONCRETE-TOKEN-ID";
    public static final String KEY_LOCALE = "CONCRETE-LOCALE";
    private static final ClosureContext<ServiceContext> CONTEXT = new StackClosureContext();
    private static final Singleton<SyncInterceptorChain> interceptorChainSingleton = Singleton.with(() -> {
        SyncInterceptorChain syncInterceptorChain = new SyncInterceptorChain();
        LazyServiceLoader<ConcreteInterceptor> serviceLoader = new LazyServiceLoader<ConcreteInterceptor>(){};
        for (ConcreteInterceptor interceptor : serviceLoader.getAll().values()) {
            if (interceptor instanceof InterceptorChain) {
                syncInterceptorChain.addAll((Collection<? extends ConcreteInterceptor>)((InterceptorChain)((Object)interceptor)).allInterceptors());
                continue;
            }
            syncInterceptorChain.add(interceptor);
        }
        return syncInterceptorChain;
    });

    public static ServiceContext getServiceContext() {
        return (ServiceContext)CONTEXT.get();
    }

    public static Object runWithContext(ServiceContext context, Supplier<?> supplier) {
        try {
            return CONTEXT.call((Object)context, supplier);
        }
        catch (Throwable throwable) {
            throw ConcreteHelper.getException(throwable);
        }
    }

    public static void runWithContext(ServiceContext context, Runnable runnable) {
        ConcreteContext.runWithContext(context, () -> {
            runnable.run();
            return null;
        });
    }

    public static Object runServiceWithContext(ServiceContext context, final Supplier<?> supplier, final Class<?> interfaceClass, Method method, Object[] params) {
        if (context instanceof ClientSideContext) {
            return ConcreteContext.runWithContext(context, supplier);
        }
        try {
            return CONTEXT.call((Object)context, () -> {
                ServiceMethodInvocation invocation = new ServiceMethodInvocation(method, params){

                    @Override
                    public Class<?> getInterfaceClass() {
                        return interfaceClass;
                    }

                    public Object proceed() {
                        return supplier.get();
                    }

                    public Object getThis() {
                        return BeanServiceLoaderProvider.getBeanProvider().getBean(interfaceClass);
                    }
                };
                try {
                    return ((SyncInterceptorChain)interceptorChainSingleton.get()).invoke(invocation);
                }
                catch (Throwable throwable) {
                    throw Common.rte((Throwable)throwable);
                }
            });
        }
        catch (Throwable throwable) {
            throw ConcreteHelper.getException(throwable);
        }
    }

    private static abstract class ServiceMethodInvocation
    implements ConcreteMethodInvocation {
        private final Object[] arguments;
        private final Method method;

        private ServiceMethodInvocation(Method method, Object[] arguments) {
            this.arguments = arguments;
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public AccessibleObject getStaticPart() {
            return null;
        }
    }
}

