/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.util.Locale;
import org.coodex.concrete.common.ConcreteLocaleProvider;
import org.coodex.concrete.common.ErrorMessageFacade;
import org.coodex.util.Common;
import org.coodex.util.Singleton;

public class ConcreteException
extends RuntimeException {
    private final int code;
    private final Object[] o;
    private final Locale locale;
    private final Singleton<String> message = Singleton.with(this::buildMessage);

    public ConcreteException(int code, Object ... objects) {
        this.code = code;
        this.o = objects;
        this.locale = ConcreteLocaleProvider.getLocalDefault();
        if (this.o != null && this.o.length > 0 && this.o[this.o.length - 1] instanceof Throwable) {
            this.initCause((Throwable)this.o[this.o.length - 1]);
            if (this.o[this.o.length - 1] instanceof ConcreteException) {
                throw (ConcreteException)this.o[this.o.length - 1];
            }
        }
    }

    private String buildMessage() {
        ErrorMessageFacade.LOCALE_CONTEXT.set(this.locale);
        try {
            String message = ErrorMessageFacade.getMessage(this.code, this.o);
            String string = Common.isBlank((String)message) ? String.format("error code: %06d", this.code) : message;
            return string;
        }
        finally {
            ErrorMessageFacade.LOCALE_CONTEXT.remove();
        }
    }

    @Override
    public String getMessage() {
        return (String)this.message.get();
    }

    public int getCode() {
        return this.code;
    }
}

