/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.coodex.concrete.api.ErrorCode;
import org.coodex.concrete.common.ErrorDefinition;
import org.coodex.util.Common;
import org.coodex.util.I18N;
import org.coodex.util.Renderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorMessageFacade {
    private static final Logger log = LoggerFactory.getLogger(ErrorMessageFacade.class);
    static final ThreadLocal<Locale> LOCALE_CONTEXT = new ThreadLocal();
    private static final Set<Class<?>> REGISTERED = new HashSet();
    private static final Map<Integer, Field> errorCodes = new HashMap<Integer, Field>();

    private ErrorMessageFacade() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerClass(Class<?> clz) {
        if (clz == null || clz.getAnnotation(ErrorCode.class) == null) {
            return;
        }
        if (!REGISTERED.contains(clz)) {
            Map<Integer, Field> map = errorCodes;
            synchronized (map) {
                if (!REGISTERED.contains(clz)) {
                    for (Field f : clz.getDeclaredFields()) {
                        if (!Integer.TYPE.equals(f.getType()) || !Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !Modifier.isPublic(f.getModifiers())) continue;
                        f.setAccessible(true);
                        try {
                            int code = f.getInt(null);
                            if (errorCodes.containsKey(code)) {
                                Field field = errorCodes.get(code);
                                if (field.equals(f)) continue;
                                log.warn("errorCode duplicate {}.{} and {}.{}", new Object[]{field.getDeclaringClass().getCanonicalName(), field.getName(), f.getDeclaringClass().getCanonicalName(), f.getName()});
                                continue;
                            }
                            errorCodes.put(code, f);
                        }
                        catch (IllegalAccessException e) {
                            log.warn("Cannot bind errorCode: {}.{}", (Object)f.getDeclaringClass().getCanonicalName(), (Object)f.getName());
                        }
                    }
                    REGISTERED.add(clz);
                }
            }
        }
    }

    public static void register(Class<?> clz) {
        ErrorMessageFacade.registerClass(clz);
    }

    public static Set<Integer> allRegisteredErrorCodes() {
        return errorCodes.keySet();
    }

    public static String getMessageTemplate(int code) {
        return ErrorMessageFacade.getMessageOrPattern(false, code, new Object[0]);
    }

    public static String getMessage(int code, Object ... objects) {
        return ErrorMessageFacade.getMessageOrPattern(true, code, objects);
    }

    private static String getNamespace(Field field) {
        if (field == null) {
            return "message";
        }
        ErrorCode errorCode = field.getDeclaringClass().getAnnotation(ErrorCode.class);
        return errorCode == null || Common.isBlank((String)errorCode.value()) ? "message" : errorCode.value();
    }

    private static String getTemplateStr(Field field, String namespace, int code) {
        if (field == null) {
            return namespace + '.' + code;
        }
        ErrorCode.Template template = field.getAnnotation(ErrorCode.Template.class);
        if (template != null && !Common.isBlank((String)template.value())) {
            return template.value();
        }
        ErrorCode.Key key = field.getAnnotation(ErrorCode.Key.class);
        return namespace + '.' + (key == null || Common.isBlank((String)key.value()) ? String.valueOf(code) : key.value());
    }

    private static String getMessageOrPattern(boolean format, int code, Object ... objects) {
        Field f = errorCodes.get(code);
        String template = I18N.translate((String)ErrorMessageFacade.getTemplateStr(f, ErrorMessageFacade.getNamespace(f), code), (Locale)LOCALE_CONTEXT.get());
        return format ? Renderer.render((String)template, (Object[])objects) : template;
    }

    public static List<ErrorDefinition> getAllErrorInfo() {
        ArrayList<ErrorDefinition> errorDefinitions = new ArrayList<ErrorDefinition>();
        for (Integer i : ErrorMessageFacade.allRegisteredErrorCodes()) {
            errorDefinitions.add(new ErrorDefinition(i));
        }
        Collections.sort(errorDefinitions);
        return errorDefinitions;
    }
}

