/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common.modules;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.coodex.concrete.api.Description;
import org.coodex.concrete.common.modules.Annotated;
import org.coodex.util.Common;
import org.coodex.util.ReflectHelper;

public abstract class AbstractParam
implements Annotated {
    private final ReflectHelper.MethodParameter parameter;
    private final Description description;

    public AbstractParam(Method method, int index) {
        this.parameter = new ReflectHelper.MethodParameter(method, index);
        this.description = this.getDeclaredAnnotation(Description.class);
    }

    public String getLabel() {
        return this.description == null ? "" : this.description.name();
    }

    public String getDescription() {
        return this.description == null ? "" : this.description.description();
    }

    public Class<?> getType() {
        return this.parameter.getType();
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.parameter.getAnnotations();
    }

    public Type getGenericType() {
        return this.parameter.getGenericType();
    }

    public String getName() {
        return Common.camelCase((String)this.parameter.getName());
    }

    public int getIndex() {
        return this.parameter.getIndex();
    }

    @Override
    public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        Target target = annotationClass.getAnnotation(Target.class);
        if (target != null && Common.inArray((Object)((Object)ElementType.ANNOTATION_TYPE), (Object[])target.value())) {
            for (Annotation annotation : this.parameter.getAnnotations()) {
                if (annotation.annotationType().equals(annotationClass)) {
                    return (T)((Annotation)Common.cast((Object)annotation));
                }
                T x = annotation.annotationType().getAnnotation(annotationClass);
                if (x == null) continue;
                return (T)((Annotation)Common.cast(x));
            }
            return null;
        }
        return (T)((Annotation)this.parameter.getAnnotation(annotationClass));
    }
}

