/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import java.lang.reflect.Field;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.validation.constraints.NotNull;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.api.Signable;
import org.coodex.concrete.api.pojo.Signature;
import org.coodex.concrete.client.ClientSideContext;
import org.coodex.concrete.common.AModule;
import org.coodex.concrete.common.AUnit;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.IronPen;
import org.coodex.concrete.common.ServerSideContext;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.common.SignatureSerializer;
import org.coodex.concrete.common.modules.AbstractParam;
import org.coodex.concrete.core.intercept.AbstractInterceptor;
import org.coodex.concrete.core.intercept.annotations.ClientSide;
import org.coodex.concrete.core.intercept.annotations.ServerSide;
import org.coodex.concrete.core.signature.Client4Elements;
import org.coodex.concrete.core.signature.ClientKeyIdAndAlgGetter;
import org.coodex.concrete.core.signature.SignUtil;
import org.coodex.config.Config;
import org.coodex.util.Common;
import org.coodex.util.I18N;
import org.coodex.util.LazyServiceLoader;
import org.coodex.util.ReflectHelper;
import org.coodex.util.ServiceLoader;
import org.coodex.util.SingletonMap;
import org.coodex.util.UUIDHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerSide
@ClientSide
public abstract class AbstractSignatureInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractSignatureInterceptor.class);
    private static final ServiceLoader<ClientKeyIdAndAlgGetter> CLIENT_KEY_ID_GETTER = new LazyServiceLoader<ClientKeyIdAndAlgGetter>((paperName, propertyKeyId, destination) -> {
        String s = Config.get((String)("signature." + propertyKeyId), (String[])new String[]{"client", destination.getIdentify(), paperName, ConcreteHelper.getAppSet()});
        if (s == null) {
            s = Config.get((String)propertyKeyId, (String[])new String[]{"client", destination.getIdentify(), ConcreteHelper.getAppSet()});
        }
        if (s == null && (s = SignUtil.getString(propertyKeyId, paperName, null)) != null) {
            log.warn("get client key id from namespace[{},{}] is deprecated. set in [{}, {}]", new Object[]{"signature", destination.getIdentify(), "client", destination.getIdentify()});
        }
        return s;
    }){};
    private static final ServiceLoader<Client4Elements> CLIENT_4_ELEMENTS = new LazyServiceLoader<Client4Elements>((module, key) -> {
        String s = Config.get((String)key, (String[])new String[]{"client", module});
        if (s == null && (s = Config.get((String)key, (String[])new String[]{"signature", module})) != null) {
            log.warn("get client signature elements[{}] from [{}, {}] is deprecated. use [{}, {}] plz.", new Object[]{key, "signature", module, "client", module});
        }
        return s;
    }){};
    private static final Supplier<String> SERVER_SIDE_VERIFY_FAILED = () -> I18N.translate((String)"sign.serverSideVerifyFailed");
    private static final Supplier<String> NO_SIGNATURE_FOUND = () -> I18N.translate((String)"sign.noSignatureFound");
    private static final SingletonMap<String, PropertyNameReload> PROPERTY_NAMES = SingletonMap.builder().function(PropertyNameReload::new).nullKey((Object)("null_" + UUIDHelper.getUUIDString())).build();
    private static final Supplier<String> NOISE_MUST_NOT_NULL = () -> String.format(I18N.translate((String)"sign.mustNotNull"), AbstractSignatureInterceptor.getPropertyName("noise"));

    private static void serverSide_Verify(DefinitionContext context, MethodInvocation joinPoint, SignUtil.HowToSign howToSign) {
        Map<String, Object> content = SignUtil.buildContent(context, joinPoint.getArguments());
        String noise = IF.isNull(AbstractSignatureInterceptor.getKeyField(content, "noise", null), 1016, NOISE_MUST_NOT_NULL);
        String algorithm = AbstractSignatureInterceptor.getKeyField(content, "algorithm", howToSign.getAlgorithm());
        String keyId = AbstractSignatureInterceptor.getKeyField(content, "keyId", null);
        SignUtil.getNoiseValidator(keyId).checkNoise(keyId, noise);
        IronPen ironPen = howToSign.getIronPenFactory(algorithm).getIronPen(howToSign.getPaperName());
        SignatureSerializer serializer = howToSign.getSerializer();
        IF.not(ironPen.verify(serializer.serialize(content), Base64.getDecoder().decode(AbstractSignatureInterceptor.getSignature(content)), algorithm, keyId), 1016, SERVER_SIDE_VERIFY_FAILED);
    }

    private static String getSignature(Map<String, Object> content) {
        String propertySign = AbstractSignatureInterceptor.getPropertyName("sign");
        String signStr = (String)content.remove(propertySign);
        if (signStr == null) {
            signStr = IF.isNull(ConcreteContext.getServiceContext().getSubjoin().get(propertySign), 1016, NO_SIGNATURE_FOUND);
        }
        return signStr;
    }

    private static Object serverSide_Sign(DefinitionContext context, MethodInvocation joinPoint, SignUtil.HowToSign howToSign, Object o) {
        try {
            if (o instanceof Signature) {
                Map<String, Object> content = SignUtil.buildContent(context, joinPoint.getArguments());
                String algorithm = AbstractSignatureInterceptor.getKeyField(content, "algorithm", howToSign.getAlgorithm());
                String keyId = AbstractSignatureInterceptor.getKeyField(content, "keyId", null);
                IronPen ironPen = howToSign.getIronPenFactory(algorithm).getIronPen(howToSign.getPaperName());
                SignatureSerializer serializer = howToSign.getSerializer();
                return AbstractSignatureInterceptor.serverSign((Signature)o, algorithm, keyId, ironPen, serializer);
            }
            return o;
        }
        catch (Throwable th) {
            throw ConcreteHelper.getException(th);
        }
    }

    private static String getKeyField(Map<String, Object> content, String keyName, String defaultValue) {
        Object key;
        String propertyName = AbstractSignatureInterceptor.getPropertyName(keyName);
        Object object = key = content.containsKey(propertyName) ? content.get(propertyName) : ConcreteContext.getServiceContext().getSubjoin().get(propertyName);
        if (key != null) {
            content.put(propertyName, key);
        }
        return key == null ? defaultValue : key.toString();
    }

    private static String putKeyField(Map<String, Object> content, String keyName, Object value, DefinitionContext context, MethodInvocation joinPoint) {
        String propertyName = AbstractSignatureInterceptor.getPropertyName(keyName);
        if (content.containsKey(propertyName)) {
            AbstractSignatureInterceptor.setArgument(context, joinPoint, propertyName, value);
        } else if (value != null) {
            ConcreteContext.getServiceContext().getSubjoin().set(propertyName, Collections.singletonList(value.toString()));
        }
        content.put(propertyName, value);
        return value == null ? null : value.toString();
    }

    private static void setArgument(DefinitionContext context, MethodInvocation joinPoint, String parameterName, Object value) {
        AUnit unit = AModule.getUnit(context.getDeclaringClass(), context.getDeclaringMethod());
        for (AbstractParam param : unit.getParameters()) {
            if (!param.getName().equals(parameterName)) continue;
            joinPoint.getArguments()[param.getIndex()] = value;
            break;
        }
    }

    public static String getPropertyName(String propertyName) {
        ServiceContext serviceContext = ConcreteContext.getServiceContext();
        if (serviceContext instanceof ClientSideContext) {
            return ((PropertyNameReload)PROPERTY_NAMES.get((Object)((ClientSideContext)serviceContext).getDestination().getIdentify())).getName(propertyName);
        }
        return ((PropertyNameReload)PROPERTY_NAMES.get(null)).getName(propertyName);
    }

    private static Object serverSign(Signature signature, String algorithm, String keyId, IronPen ironPen, SignatureSerializer serializer) throws IllegalAccessException {
        signature.setNoise(SignUtil.getNoiseGenerator(keyId).generateNoise());
        signature.setSign(Base64.getEncoder().encodeToString(ironPen.sign(serializer.serialize(AbstractSignatureInterceptor.signatureToMap(signature)), algorithm, keyId)));
        return signature;
    }

    private static Map<String, Object> signatureToMap(Signature signature) throws IllegalAccessException {
        if (signature == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Field field : ReflectHelper.getAllDeclaredFields(signature.getClass())) {
            if (field.getDeclaringClass().equals(Signature.class) && !"noise".equals(field.getName())) continue;
            field.setAccessible(true);
            result.put(field.getName(), field.get(signature));
        }
        return result;
    }

    @Override
    public int getOrder() {
        return 900;
    }

    @Override
    protected boolean accept_(DefinitionContext context) {
        return context.getAnnotation(Signable.class) != null;
    }

    @Override
    public void before(DefinitionContext context, MethodInvocation joinPoint) {
        SignUtil.HowToSign howToSign = SignUtil.howToSign(context);
        ServiceContext serviceContext = ConcreteContext.getServiceContext();
        if (serviceContext instanceof ServerSideContext) {
            AbstractSignatureInterceptor.serverSide_Verify(context, joinPoint, howToSign);
        } else if (serviceContext instanceof ClientSideContext) {
            this.clientSide_Sign(context, joinPoint, howToSign);
        }
    }

    @Override
    public Object after(DefinitionContext context, MethodInvocation joinPoint, Object result) {
        SignUtil.HowToSign howToSign = SignUtil.howToSign(context);
        ServiceContext serviceContext = ConcreteContext.getServiceContext();
        if (serviceContext instanceof ServerSideContext) {
            return AbstractSignatureInterceptor.serverSide_Sign(context, joinPoint, howToSign, result);
        }
        if (serviceContext instanceof ClientSideContext) {
            return this.clientSide_Verify(context, joinPoint, howToSign, result);
        }
        return result;
    }

    private void clientSide_Sign(DefinitionContext context, MethodInvocation joinPoint, SignUtil.HowToSign howToSign) {
        Map<String, Object> content = SignUtil.buildContent(context, joinPoint.getArguments());
        String keyId = AbstractSignatureInterceptor.putKeyField(content, "keyId", ((ClientKeyIdAndAlgGetter)CLIENT_KEY_ID_GETTER.get()).getValue(howToSign.getPaperName(), AbstractSignatureInterceptor.getPropertyName("keyId"), ((ClientSideContext)ConcreteContext.getServiceContext()).getDestination()), context, joinPoint);
        String noise = SignUtil.getNoiseGenerator(keyId).generateNoise();
        AbstractSignatureInterceptor.putKeyField(content, "noise", noise, context, joinPoint);
        String algorithm = AbstractSignatureInterceptor.putKeyField(content, "algorithm", ((ClientKeyIdAndAlgGetter)CLIENT_KEY_ID_GETTER.get()).getValue(howToSign.getPaperName(), AbstractSignatureInterceptor.getPropertyName("algorithm"), ((ClientSideContext)ConcreteContext.getServiceContext()).getDestination()), context, joinPoint);
        if (algorithm == null) {
            algorithm = howToSign.getAlgorithm();
        }
        byte[] data = howToSign.getSerializer().serialize(content);
        String sign = Base64.getEncoder().encodeToString(howToSign.getIronPenFactory(algorithm).getIronPen(howToSign.getPaperName()).sign(data, algorithm, keyId));
        AbstractSignatureInterceptor.putKeyField(content, "sign", sign, context, joinPoint);
        if (log.isDebugEnabled()) {
            log.debug("signature for[ {} ]: \n\t{}: {}\n\t{}: {}\n\t{}: {}\n\t{}: {}\n\t{}: {}", new Object[]{context.getDeclaringMethod().getName(), AbstractSignatureInterceptor.getPropertyName("noise"), noise, AbstractSignatureInterceptor.getPropertyName("algorithm"), algorithm, AbstractSignatureInterceptor.getPropertyName("keyId"), keyId, AbstractSignatureInterceptor.getPropertyName("sign"), sign, "body", this.dataToString(data)});
        }
    }

    private Object clientSide_Verify(DefinitionContext context, MethodInvocation joinPoint, SignUtil.HowToSign howToSign, Object o) {
        try {
            if (o instanceof Signature) {
                Map<String, Object> content = SignUtil.buildContent(context, joinPoint.getArguments());
                String algorithm = AbstractSignatureInterceptor.putKeyField(content, "algorithm", SignUtil.getString("algorithm", howToSign.getPaperName(), null), context, joinPoint);
                if (algorithm == null) {
                    algorithm = howToSign.getAlgorithm();
                }
                String keyId = AbstractSignatureInterceptor.putKeyField(content, "keyId", SignUtil.getString("keyId", howToSign.getPaperName(), null), context, joinPoint);
                this.clientVerify(howToSign, (Signature)o, algorithm, keyId);
            }
            return o;
        }
        catch (Throwable th) {
            throw ConcreteHelper.getException(th);
        }
    }

    private void clientVerify(SignUtil.HowToSign howToSign, @NotNull Signature signature, String algorithm, String keyId) throws IllegalAccessException {
        IF.not(howToSign.getIronPenFactory(algorithm).getIronPen(howToSign.getPaperName()).verify(howToSign.getSerializer().serialize(AbstractSignatureInterceptor.signatureToMap(signature)), Base64.getDecoder().decode(signature.getSign()), algorithm, keyId), 1016, "client side verify failed.");
    }

    protected abstract String dataToString(byte[] var1);

    private static class PropertyNameReload {
        private final String module;
        private final Map<String, String> mapping = new HashMap<String, String>();

        PropertyNameReload(String module) {
            this.module = module;
            this.mapping.put("keyId", this.initLoad("keyId"));
            this.mapping.put("sign", this.initLoad("sign"));
            this.mapping.put("algorithm", this.initLoad("algorithm"));
            this.mapping.put("noise", this.initLoad("noise"));
        }

        private String initLoad(String propertyName) {
            if (Common.isBlank((String)this.module)) {
                String s = Config.get((String)("signature.property." + propertyName), (String[])new String[]{"signature", ConcreteHelper.getAppSet()});
                if (s == null && !propertyName.equals(s = (String)Config.getValue((String)("property." + propertyName), (Object)propertyName, (String[])new String[]{"signature", ConcreteHelper.getAppSet()}))) {
                    log.warn("property.{} is deprecated. use signature.property.{} plz.", (Object)propertyName, (Object)propertyName);
                }
                return s == null ? propertyName : s;
            }
            String s = ((Client4Elements)CLIENT_4_ELEMENTS.get()).getElementsName(this.module, "signature.property." + propertyName);
            if (s == null) {
                s = ((Client4Elements)CLIENT_4_ELEMENTS.get()).getElementsName(this.module, "property." + propertyName);
            }
            return s == null ? propertyName : s;
        }

        String getName(String key) {
            return this.mapping.get(key);
        }
    }
}

