/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.core.intercept.AbstractInterceptor;
import org.coodex.concrete.core.intercept.ConcreteInterceptor;
import org.coodex.concrete.core.intercept.ConcreteSyncInterceptor;
import org.coodex.concrete.core.intercept.annotations.ClientSide;
import org.coodex.concrete.core.intercept.annotations.Default;
import org.coodex.concrete.core.intercept.annotations.Local;
import org.coodex.concrete.core.intercept.annotations.ServerSide;
import org.coodex.concrete.core.intercept.annotations.TestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSyncInterceptor
extends AbstractInterceptor
implements ConcreteSyncInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractSyncInterceptor.class);

    public Object invoke(MethodInvocation invocation) throws Throwable {
        DefinitionContext context = AbstractSyncInterceptor.getContext(invocation);
        if (context == null || !this.accept(context)) {
            return invocation.proceed();
        }
        this.before(context, invocation);
        try {
            Object result = this.around(context, invocation);
            try {
                result = this.after(context, invocation, result);
            }
            catch (Throwable t) {
                log.warn("Error occurred in afterAdvice. {}", (Object)t.getLocalizedMessage(), (Object)t);
            }
            return result;
        }
        catch (ConcreteException ce) {
            throw ce;
        }
        catch (Throwable t) {
            Throwable t2 = this.onError(context, invocation, t);
            throw t2 == null ? t : t2;
        }
    }

    @Override
    public Object around(DefinitionContext context, MethodInvocation joinPoint) throws Throwable {
        return joinPoint.proceed();
    }

    protected ConcreteSyncInterceptor asyncToSync(ConcreteInterceptor interceptor) {
        return new InnerSyncInterceptor(interceptor);
    }

    @ServerSide
    @ClientSide
    @Local
    @Default
    @TestContext
    public static class InnerSyncInterceptor
    extends AbstractSyncInterceptor {
        private final ConcreteInterceptor interceptor;

        InnerSyncInterceptor(ConcreteInterceptor interceptor) {
            this.interceptor = interceptor;
        }

        @Override
        public int getOrder() {
            return this.interceptor.getOrder();
        }

        @Override
        public boolean accept_(DefinitionContext context) {
            return this.interceptor.accept(context);
        }

        @Override
        public void before(DefinitionContext context, MethodInvocation joinPoint) {
            this.interceptor.before(context, joinPoint);
        }

        @Override
        public Object after(DefinitionContext context, MethodInvocation joinPoint, Object result) {
            return this.interceptor.after(context, joinPoint, result);
        }

        @Override
        public Throwable onError(DefinitionContext context, MethodInvocation joinPoint, Throwable th) {
            return this.interceptor.onError(context, joinPoint, th);
        }
    }
}

