/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import org.coodex.concrete.api.LimitingStrategy;
import org.coodex.concrete.api.limiting.TokenBucket;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.config.Config;
import org.coodex.id.IDGenerator;
import org.coodex.util.Clock;
import org.coodex.util.Common;
import org.coodex.util.SingletonMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenBucketLimiting
implements LimitingStrategy {
    private static final Logger log = LoggerFactory.getLogger(TokenBucketLimiting.class);
    private static final String DEFAULT_BUCKET = IDGenerator.newId();
    private static final SingletonMap<String, Bucket> BUCKET_SINGLETON_MAP = SingletonMap.builder().function(key -> {
        String[] namespace = DEFAULT_BUCKET.equalsIgnoreCase((String)key) ? new String[]{"tokenBucket", ConcreteHelper.getAppSet()} : new String[]{"tokenBucket", ConcreteHelper.getAppSet(), key};
        int capacity = Math.max(1, (Integer)Config.getValue((String)"capacity", (Object)Common.toInt((String)System.getProperty("tokenBucket.capacity"), (int)0x3FFFFFFF), (String[])namespace));
        int flow = Math.max(1, (Integer)Config.getValue((String)"flow", (Object)Common.toInt((String)System.getProperty("tokenBucket.flow"), (int)Short.MAX_VALUE), (String[])namespace));
        Bucket bucket = new Bucket(capacity, flow);
        bucket.name = key;
        return bucket;
    }).build();

    public boolean apply(DefinitionContext definitionContext) {
        String bucketName = DEFAULT_BUCKET;
        int used = 1;
        TokenBucket tokenBucket = (TokenBucket)definitionContext.getAnnotation(TokenBucket.class);
        if (tokenBucket != null) {
            if (!Common.isBlank((String)tokenBucket.bucket())) {
                bucketName = tokenBucket.bucket();
            }
            used = Math.max(used, tokenBucket.tokenUsed());
        }
        return ((Bucket)BUCKET_SINGLETON_MAP.get((Object)bucketName)).alloc(used);
    }

    public void release(DefinitionContext definitionContext) {
    }

    public boolean accept(DefinitionContext param) {
        return param.getAnnotation(TokenBucket.class) != null;
    }

    private static class Bucket {
        private final int capacity;
        private final int flow;
        private long lastChecked;
        private int count;
        private String name;

        private Bucket(int capacity, int flow) {
            this.capacity = capacity;
            this.flow = flow;
            this.lastChecked = Clock.currentTimeMillis();
            this.count = capacity;
        }

        private void flowIn() {
            long x = Clock.currentTimeMillis();
            if (x == this.lastChecked) {
                return;
            }
            int flowIn = (int)(1.0 * (double)this.flow * (double)(x - this.lastChecked) / 1000.0);
            if (flowIn > 0) {
                int beforeFlowIn = this.count;
                this.count = Math.min(this.capacity, beforeFlowIn + flowIn);
                int actuallyFlowIn = this.count - beforeFlowIn;
                if (actuallyFlowIn > 0) {
                    log.info("[{}]tokens flow in: {}, current: {}, from {} to {}", new Object[]{DEFAULT_BUCKET.equals(this.name) ? "GLOBAL" : this.name, actuallyFlowIn, this.count, this.lastChecked, x});
                }
                this.lastChecked = x;
            }
        }

        synchronized boolean alloc(int tokenCount) {
            this.flowIn();
            if (this.count >= tokenCount) {
                this.count -= tokenCount;
                log.info("[{}]tokens picked: {}, remain: {}", new Object[]{DEFAULT_BUCKET.equals(this.name) ? "GLOBAL" : this.name, tokenCount, this.count});
                return true;
            }
            return false;
        }
    }
}

