/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.token.local;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.coodex.concrete.common.Account;
import org.coodex.concrete.common.AccountFactory;
import org.coodex.concrete.common.BeanServiceLoaderProvider;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.token.AbstractToken;
import org.coodex.id.IDGenerator;
import org.coodex.util.Clock;
import org.coodex.util.Common;

class LocalToken
extends AbstractToken {
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final long created = Clock.currentTimeMillis();
    private Serializable currentAccountId = null;
    private boolean accountCredible = false;
    private boolean valid = true;
    private long lastActive;
    private String sessionId = IDGenerator.newId();

    public LocalToken(String sessionId) {
        if (sessionId != null) {
            this.sessionId = sessionId;
        }
        this.active();
        this.runListeners(Token.Event.CREATED, false);
    }

    void active() {
        this.lastActive = Clock.currentTimeMillis();
    }

    public long getLastActive() {
        return this.lastActive;
    }

    public long created() {
        return this.created;
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    protected void $invalidate() {
        this.attributes.clear();
        this.currentAccountId = null;
        this.accountCredible = false;
        this.valid = false;
    }

    public Account<?> currentAccount() {
        if (this.currentAccountId == null) {
            return null;
        }
        AccountFactory accountFactory = BeanServiceLoaderProvider.getBeanProvider().getBean(AccountFactory.class);
        return accountFactory.getAccountByID((Serializable)Common.cast((Object)this.currentAccountId));
    }

    public void setAccount(Account<?> account) {
        this.currentAccountId = account.getId();
    }

    public boolean isAccountCredible() {
        return this.currentAccountId != null && this.accountCredible;
    }

    public void setAccountCredible(boolean credible) {
        this.accountCredible = credible;
    }

    public String getTokenId() {
        return this.sessionId;
    }

    public <T> T getAttribute(String key, Class<T> tClass) {
        return (T)Common.cast((Object)this.attributes.get(key));
    }

    public void setAttribute(String key, Serializable attribute) {
        this.attributes.put(key, attribute);
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public Enumeration<String> attributeNames() {
        return new Vector<String>(this.attributes.keySet()).elements();
    }

    public void flush() {
    }

    @Override
    protected void $renew() {
        if (!this.valid) {
            this.valid = true;
        }
    }

    public String toString() {
        return "LocalToken{attributes=" + this.attributes + ", currentAccountId=" + this.currentAccountId + ", accountCredible=" + this.accountCredible + ", valid=" + this.valid + ", lastActive=" + this.lastActive + ", sessionId='" + this.sessionId + '\'' + ", created=" + this.created + '}';
    }
}

