/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.message;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.bytecode.javassist.JavassistHelper;
import org.coodex.concrete.message.AbstractTopic;
import org.coodex.concrete.message.Courier;
import org.coodex.concrete.message.CourierBuilder;
import org.coodex.concrete.message.DefaultTopicPrototypeProvider;
import org.coodex.concrete.message.Queue;
import org.coodex.concrete.message.TopicKey;
import org.coodex.concrete.message.TopicPrototypeProvider;
import org.coodex.util.Common;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.SelectableServiceLoader;
import org.coodex.util.SingletonMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TopicBuilder
implements Function<TopicKey, AbstractTopic> {
    private static final Logger log = LoggerFactory.getLogger(TopicBuilder.class);
    private static final TopicPrototypeProvider defaultTopicPrototypeProvider = new DefaultTopicPrototypeProvider();
    private static SelectableServiceLoader<Class<?>, TopicPrototypeProvider> topicPrototypeProviderLoader = new LazySelectableServiceLoader<Class<?>, TopicPrototypeProvider>(defaultTopicPrototypeProvider){};
    private static SingletonMap<TopicKey, AbstractTopic> topics = SingletonMap.builder().function((Function)new TopicBuilder()).build();
    private AtomicLong index = new AtomicLong(0L);

    TopicBuilder() {
    }

    static AbstractTopic buildTopic(TopicKey key) {
        return (AbstractTopic)topics.get((Object)TopicKey.copy(key));
    }

    private Class<? extends AbstractTopic> getClass(Type topicType) {
        if (topicType instanceof ParameterizedType) {
            return (Class)Common.cast((Object)((ParameterizedType)topicType).getRawType());
        }
        if (topicType instanceof Class && AbstractTopic.class.isAssignableFrom((Class)topicType)) {
            return (Class)Common.cast((Object)topicType);
        }
        throw new RuntimeException(topicType + " is NOT SUPPORTED.");
    }

    public Annotation queue(ConstPool constPool, String queue) {
        Annotation annotation = new Annotation(Queue.class.getName(), constPool);
        annotation.addMemberValue("value", (MemberValue)new StringMemberValue(queue == null ? "" : queue, constPool));
        return annotation;
    }

    @Override
    public AbstractTopic apply(TopicKey key) {
        try {
            Class<? extends AbstractTopic> topicClass = this.getClass(key.topicType);
            TopicPrototypeProvider provider = (TopicPrototypeProvider)topicPrototypeProviderLoader.select(topicClass);
            if (provider == null && defaultTopicPrototypeProvider.accept(topicClass)) {
                provider = defaultTopicPrototypeProvider;
            }
            Class<?> prototype = Optional.ofNullable(provider).orElseThrow(() -> ConcreteHelper.getException("No provider for " + topicClass.getName())).getPrototype();
            Courier courier = CourierBuilder.buildCourier(key);
            ClassPool classPool = ClassPool.getDefault();
            String className = String.format("%s.Topic$$CBC$$%08X", TopicBuilder.class.getPackage().getName(), this.index.incrementAndGet());
            CtClass ctClass = classPool.makeClass(className, JavassistHelper.getCtClass(prototype, classPool));
            ctClass.setInterfaces(new CtClass[]{JavassistHelper.getCtClass(topicClass, classPool)});
            ClassFile classFile = ctClass.getClassFile();
            classFile.setVersionToJava5();
            ConstPool constPool = classFile.getConstPool();
            if (key.queue != null) {
                classFile.addAttribute((AttributeInfo)JavassistHelper.aggregate(constPool, this.queue(constPool, key.queue)));
            }
            ctClass.setGenericSignature(new SignatureAttribute.ClassSignature(null, JavassistHelper.classType(prototype.getName(), CourierBuilder.getMessageType(key.topicType)), new SignatureAttribute.ClassType[]{JavassistHelper.classType(topicClass.getName(), CourierBuilder.getMessageType(key.topicType))}).encode());
            CtConstructor ctConstructor = new CtConstructor(new CtClass[]{JavassistHelper.getCtClass(Courier.class, classPool)}, ctClass);
            ctConstructor.setBody("{super($$);}");
            ctClass.addConstructor(ctConstructor);
            Class newClass = (Boolean)JavassistHelper.IS_JAVA_9_AND_LAST.get() != false ? ctClass.toClass(TopicBuilder.class) : ctClass.toClass();
            Constructor constructor = newClass.getConstructor(Courier.class);
            AbstractTopic abstractTopic = (AbstractTopic)Common.cast(constructor.newInstance(courier));
            log.info("Topic build. {} for {}", (Object)abstractTopic.getClass().getName(), (Object)key.toString());
            return abstractTopic;
        }
        catch (Throwable th) {
            throw Common.rte((Throwable)th);
        }
    }
}

