/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.own;

import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.coodex.concrete.api.Application;
import org.coodex.concrete.apm.APM;
import org.coodex.concrete.apm.Trace;
import org.coodex.concrete.common.BeanServiceLoaderProvider;
import org.coodex.concrete.common.Caller;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ErrorCodeConstants;
import org.coodex.concrete.common.ErrorMessageFacade;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.JSONSerializerFactory;
import org.coodex.concrete.common.ServerSideContext;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.common.modules.AbstractUnit;
import org.coodex.concrete.message.ServerSideMessage;
import org.coodex.concrete.message.TBMContainer;
import org.coodex.concrete.own.OwnServiceModule;
import org.coodex.concrete.own.OwnServiceSubjoin;
import org.coodex.concrete.own.OwnServiceUnit;
import org.coodex.concrete.own.PackageHelper;
import org.coodex.concrete.own.RequestPackage;
import org.coodex.concrete.own.ResponsePackage;
import org.coodex.concurrent.components.PriorityRunnable;
import org.coodex.util.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OwnServiceProvider
implements Application {
    private static final Logger log = LoggerFactory.getLogger(OwnServiceProvider.class);
    private final Map<String, AbstractUnit<?>> unitMap = new HashMap();

    public OwnServiceProvider() {
        this.registerPackage(ErrorCodeConstants.class.getPackage().getName());
    }

    protected Subjoin getSubjoin(RequestPackage<?> requestPackage) {
        return this.getSubjoin(requestPackage.getSubjoin());
    }

    protected Locale getLocale(Subjoin subjoin) {
        if (subjoin != null && !Common.isBlank((String)subjoin.get("locale"))) {
            try {
                return LanguageTag.valueOf(subjoin.get("locale")).getAsLocale();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Locale.getDefault();
    }

    private void appendUnits(OwnServiceModule<?> module) {
        for (OwnServiceUnit unit : (OwnServiceUnit[])module.getUnits()) {
            this.unitMap.put(unit.getKey(), unit);
        }
    }

    public final void registerPackage(String ... packages) {
        if (packages == null || packages.length == 0) {
            ConcreteHelper.foreachClassInPackages(xva$0 -> this.registerClasses((Class<?>)xva$0), ConcreteHelper.getApiPackages(this.getNamespace()));
        } else {
            ConcreteHelper.foreachClassInPackages(xva$0 -> this.registerClasses((Class<?>)xva$0), packages);
        }
    }

    public void register(Class<?> ... classes) {
        this.registerClasses(classes);
    }

    public final void registerClasses(Class<?> ... classes) {
        for (Class<?> clz : classes) {
            ErrorMessageFacade.register(clz);
            if (!ConcreteHelper.isConcreteService(clz)) {
                throw new RuntimeException("cannot register class:" + clz.getName());
            }
            this.appendUnits(this.getModuleBuilder().build(clz));
        }
    }

    protected abstract OwnModuleBuilder getModuleBuilder();

    protected Subjoin getSubjoin(Map<String, String> map) {
        return new OwnServiceSubjoin(map).wrap();
    }

    protected abstract ServerSideContext getServerSideContext(RequestPackage<Object> var1, String var2, Caller var3);

    protected void invokeService(final RequestPackage<Object> requestPackage, final Caller caller, final ResponseVisitor responseVisitor, final ErrorVisitor errorVisitor, final ServerSideMessageVisitor serverSideMessageVisitor, final TBMNewTokenVisitor newTokenVisitor) {
        IF.isNull(responseVisitor, 1200, this.getModuleName());
        final AbstractUnit<?> unit = IF.isNull(this.unitMap.get(requestPackage.getServiceId()), 1201, requestPackage.getServiceId());
        final Object[] objects = PackageHelper.analysisParameters(JSONSerializerFactory.getInstance().toJson(requestPackage.getContent()), unit);
        final String tokenId = requestPackage.getConcreteTokenId();
        ConcreteHelper.getExecutor().execute((Runnable)new PriorityRunnable(ConcreteHelper.getPriority(unit), new Runnable(){
            private final Method method;
            {
                this.method = unit.getMethod();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ServerSideContext context = OwnServiceProvider.this.getServerSideContext(requestPackage, tokenId, caller);
                Trace trace = APM.build(context.getSubjoin()).tag("remote", context.getCaller().getAddress()).tag("agent", context.getCaller().getClientProvider()).start(String.format("%s: %s.%s", OwnServiceProvider.this.getModuleName(), this.method.getDeclaringClass().getName(), this.method.getName()));
                try {
                    Object result = ConcreteContext.runServiceWithContext(context, () -> {
                        Object instance = BeanServiceLoaderProvider.getBeanProvider().getBean((Class)Common.cast(unit.getDeclaringModule().getInterfaceClass()));
                        try {
                            if (objects == null) {
                                return this.method.invoke(instance, new Object[0]);
                            }
                            return this.method.invoke(instance, objects);
                        }
                        catch (Throwable t) {
                            throw Common.rte((Throwable)t);
                        }
                    }, unit.getDeclaringModule().getInterfaceClass(), unit.getMethod(), objects);
                    ResponsePackage<Object> responsePackage = new ResponsePackage<Object>();
                    final String tokenIdAfterInvoke = context.getTokenId();
                    if (!Objects.equals(tokenId, tokenIdAfterInvoke) && !Common.isBlank((String)tokenIdAfterInvoke)) {
                        responsePackage.setConcreteTokenId(tokenIdAfterInvoke);
                        if (!Common.isBlank((String)tokenId)) {
                            if (newTokenVisitor != null) {
                                newTokenVisitor.visit(tokenIdAfterInvoke);
                            }
                            TBMContainer.getInstance().clear(tokenId);
                        }
                        TBMContainer.getInstance().listen(tokenIdAfterInvoke, new TBMContainer.TBMListener(){

                            @Override
                            public String getTokenId() {
                                return tokenIdAfterInvoke;
                            }

                            @Override
                            public void onMessage(ServerSideMessage<?> serverSideMessage) {
                                serverSideMessageVisitor.visit(serverSideMessage, tokenIdAfterInvoke);
                            }
                        });
                    }
                    responsePackage.setSubjoin(ConcreteHelper.updatedMap(context.getSubjoin()));
                    responsePackage.setMsgId(requestPackage.getMsgId());
                    responsePackage.setOk(true);
                    responsePackage.setContent(Common.cast((Object)result));
                    responseVisitor.visit(responsePackage);
                }
                catch (Throwable th) {
                    trace.error(th);
                    if (errorVisitor != null) {
                        errorVisitor.visit(requestPackage.getMsgId(), th);
                    } else {
                        log.warn("no error visitor: {}", (Object)OwnServiceProvider.this.getModuleName());
                    }
                }
                finally {
                    trace.finish();
                }
            }
        }));
    }

    protected abstract String getModuleName();

    public static abstract class DefaultResponseVisitor
    implements ResponseVisitor {
        @Override
        public void visit(ResponsePackage<?> responsePackage) {
            this.visit(JSONSerializerFactory.getInstance().toJson(responsePackage));
        }
    }

    public static class LanguageTag {
        String tag;
        String primaryTag;
        String subTags;

        LanguageTag() {
        }

        public LanguageTag(String primaryTag, String subTags) {
            this.tag = subTags != null && subTags.length() > 0 ? primaryTag + "-" + subTags : primaryTag;
            this.primaryTag = primaryTag;
            this.subTags = subTags;
        }

        public static LanguageTag valueOf(String s) throws IllegalArgumentException {
            LanguageTag lt = new LanguageTag();
            try {
                lt.parse(s);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException(pe);
            }
            return lt;
        }

        public final boolean isCompatible(Locale tag) {
            if (this.tag.equals("*")) {
                return true;
            }
            if (this.subTags == null) {
                return this.primaryTag.equalsIgnoreCase(tag.getLanguage());
            }
            return this.primaryTag.equalsIgnoreCase(tag.getLanguage()) && this.subTags.equalsIgnoreCase(tag.getCountry());
        }

        final Locale getAsLocale() {
            return this.subTags == null ? new Locale(this.primaryTag) : new Locale(this.primaryTag, this.subTags);
        }

        protected final void parse(String languageTag) throws ParseException {
            if (!this.isValid(languageTag)) {
                throw new ParseException("String, " + languageTag + ", is not a valid language tag", 0);
            }
            int index = languageTag.indexOf(45);
            if (index == -1) {
                this.primaryTag = languageTag;
                this.subTags = null;
            } else {
                this.primaryTag = languageTag.substring(0, index);
                this.subTags = languageTag.substring(index + 1);
            }
        }

        private boolean isValid(String tag) {
            int alphanumCount = 0;
            int dash = 0;
            for (int i = 0; i < tag.length(); ++i) {
                char c = tag.charAt(i);
                if (c == '-') {
                    if (alphanumCount == 0) {
                        return false;
                    }
                    alphanumCount = 0;
                    ++dash;
                    continue;
                }
                if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || dash > 0 && '0' <= c && c <= '9') {
                    if (++alphanumCount <= 8) continue;
                    return false;
                }
                return false;
            }
            return alphanumCount != 0;
        }

        public final String getTag() {
            return this.tag;
        }

        public final String getPrimaryTag() {
            return this.primaryTag;
        }

        public final String getSubTags() {
            return this.subTags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LanguageTag) || o.getClass() != this.getClass()) {
                return false;
            }
            LanguageTag that = (LanguageTag)o;
            if (!Objects.equals(this.primaryTag, that.primaryTag)) {
                return false;
            }
            if (!Objects.equals(this.subTags, that.subTags)) {
                return false;
            }
            return Objects.equals(this.tag, that.tag);
        }

        public int hashCode() {
            int result = this.tag != null ? this.tag.hashCode() : 0;
            result = 31 * result + (this.primaryTag != null ? this.primaryTag.hashCode() : 0);
            result = 31 * result + (this.subTags != null ? this.subTags.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.primaryTag + (this.subTags == null ? "" : this.subTags);
        }
    }

    public static interface OwnModuleBuilder {
        public OwnServiceModule<?> build(Class<?> var1);
    }

    public static interface TBMNewTokenVisitor {
        public void visit(String var1);
    }

    public static interface ServerSideMessageVisitor {
        public void visit(ServerSideMessage<?> var1, String var2);
    }

    public static interface ErrorVisitor {
        public void visit(String var1, Throwable var2);
    }

    public static interface ResponseVisitor {
        public void visit(ResponsePackage<?> var1);

        public void visit(String var1);
    }
}

