/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.regex.Pattern;
import org.coodex.concrete.common.AccountID;
import org.coodex.util.CRC;

public class ClassifiableAccountID
implements AccountID,
Serializable {
    private static final Pattern ID_PATTERN = Pattern.compile("^\\d+::[^ :\\f\\n\\r\\t\\v]+::\\d+$");
    private final Integer category;
    private String id;

    public ClassifiableAccountID(Integer category) {
        this(category, null);
    }

    public ClassifiableAccountID(Integer category, String id) {
        if (category == null) {
            throw new NullPointerException("category MUST NOT null.");
        }
        this.category = category;
        this.id = id;
    }

    public static boolean accept(String idStr) {
        return idStr != null && ID_PATTERN.matcher(idStr).matches();
    }

    public static ClassifiableAccountID valueOf(String str) {
        if (str == null) {
            throw new NullPointerException("ClassifiableAccountID cannot parse from null.");
        }
        if (!ID_PATTERN.matcher(str).matches()) {
            throw new IllegalArgumentException(str + " is NOT ClassifiableAccountID");
        }
        String[] array = str.split("::");
        ClassifiableAccountID id = new ClassifiableAccountID(Integer.valueOf(array[0]), array[1]);
        if (str.equals(id.serialize())) {
            return id;
        }
        throw new IllegalArgumentException(str + " is NOT valid ClassifiableAccountID");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassifiableAccountID)) {
            return false;
        }
        ClassifiableAccountID that = (ClassifiableAccountID)o;
        if (!Objects.equals(this.category, that.category)) {
            return false;
        }
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        int result = this.category != null ? this.category.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public Integer getCategory() {
        return this.category;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String serialize() {
        String x = String.format("%d::%s", this.category, this.id);
        return String.format("%s::%d", x, CRC.calculateCRC((CRC.Algorithm)CRC.Algorithm.CRC16_MODBUS, (byte[])x.getBytes(Charset.forName("UTF-8"))));
    }
}

