/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.util.HashSet;
import java.util.Set;
import org.coodex.concrete.common.Account;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.token.TokenWrapper;
import org.coodex.util.Common;

public class RBACHelper {
    public static void rbac(String[] acl) {
        RBACHelper.rbac(acl, true);
    }

    public static void rbac(String[] acl, boolean safely) {
        RBACHelper.rbac(acl, null, safely);
    }

    public static void rbac(String[] acl, String domain, boolean safely) {
        RBACHelper.rbac(RBACHelper.getCurrentAccount(), acl, domain, safely);
    }

    public static void rbac(Account<?> account, String[] acl) {
        RBACHelper.rbac(account, acl, true);
    }

    public static void rbac(Account<?> account, String[] acl, boolean safely) {
        RBACHelper.rbac(account, acl, null, safely);
    }

    public static void rbac(Account<?> account, String[] acl, String domain, boolean safely) {
        if (acl != null) {
            Set<String> matching;
            Account<?> currentAccount = RBACHelper.getCurrentAccount();
            Token token = TokenWrapper.getInstance();
            IF.isNull(currentAccount, 1005, token);
            IF.not(currentAccount.isValid(), 1007, new Object[0]);
            if (safely) {
                IF.not(token.isAccountCredible(), 1008, new Object[0]);
            }
            IF.is((matching = RBACHelper.matching(account, acl, domain)).size() == 0, 1006, new Object[0]);
        }
    }

    public static Set<String> matching(String[] roles, String domain) {
        return RBACHelper.matching(RBACHelper.getCurrentAccount(), roles, domain);
    }

    public static Set<String> matching(Account<?> account, String[] roles, String domain) {
        if (roles == null) {
            throw new NullPointerException("roles MUST be NOT NULL.");
        }
        Set<String> accountDomainRoles = RBACHelper.getAccountDomainRoles(domain, account);
        Set toCheck = Common.arrayToSet((Object[])roles);
        if (accountDomainRoles.contains("*")) {
            return toCheck;
        }
        return Common.intersection((Set)toCheck, accountDomainRoles);
    }

    private static Account<?> getCurrentAccount() {
        return TokenWrapper.getInstance().currentAccount();
    }

    private static Set<String> getAccountDomainRoles(String domain, Account<?> account) {
        if (account == null) {
            throw new RuntimeException("account MUST be NOT NULL.");
        }
        HashSet<String> accountDomainRoles = new HashSet<String>();
        Set accountRoles = account.getRoles();
        if (accountRoles != null) {
            if (Common.isBlank((String)domain)) {
                accountDomainRoles.addAll(accountRoles);
            } else {
                int domainPrefixLen = domain.length() + 1;
                for (String role : accountRoles) {
                    if (Common.isBlank((String)role)) continue;
                    if (role.equals("*")) {
                        accountDomainRoles.add("*");
                        break;
                    }
                    if (role.startsWith("*.") && role.length() > 2) {
                        accountDomainRoles.add(role.substring(2));
                        continue;
                    }
                    if (!role.startsWith(domain + ".") || role.length() <= domainPrefixLen) continue;
                    accountDomainRoles.add(role.substring(domainPrefixLen));
                }
            }
        }
        if (!Common.isBlank((String)domain)) {
            if (accountDomainRoles.size() > 0) {
                accountDomainRoles.add("EVERYBODY");
            }
        } else {
            accountDomainRoles.add("EVERYBODY");
        }
        return accountDomainRoles;
    }
}

