/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.signature;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.coodex.concrete.api.Signable;
import org.coodex.concrete.client.ClientSideContext;
import org.coodex.concrete.common.AModule;
import org.coodex.concrete.common.AUnit;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.IronPenFactory;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.common.SignatureSerializer;
import org.coodex.concrete.common.SubjoinWrapper;
import org.coodex.concrete.common.modules.AbstractParam;
import org.coodex.concrete.core.intercept.AbstractSignatureInterceptor;
import org.coodex.concrete.core.signature.DefaultSignatureSerializer;
import org.coodex.concrete.core.signature.NoiseGenerator;
import org.coodex.concrete.core.signature.NoiseValidator;
import org.coodex.config.Config;
import org.coodex.util.Common;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.LazyServiceLoader;
import org.coodex.util.Profile;
import org.coodex.util.ServiceLoader;

public class SignUtil {
    public static final String KEY_FIELD_ALGORITHM = "algorithm";
    public static final String KEY_FIELD_SIGN = "sign";
    public static final String KEY_FIELD_KEY_ID = "keyId";
    public static final String KEY_FIELD_NOISE = "noise";
    public static final String TAG_SIGNATURE = "signature";
    private static final LazySelectableServiceLoader<String, IronPenFactory> IRON_PEN_FACTORY_CONCRETE_SPI_FACADE = new LazySelectableServiceLoader<String, IronPenFactory>(){};
    private static final SignatureSerializer DEFAULT_SERIALIZER = new DefaultSignatureSerializer();
    private static final ServiceLoader<SignatureSerializer> SIGNATURE_SERIALIZER_CONCRETE_SPI_FACADE = new LazyServiceLoader<SignatureSerializer>(DEFAULT_SERIALIZER){};
    private static final NoiseValidator defaultValidator = new NoiseValidator(){

        @Override
        public void checkNoise(String keyId, String noise) {
        }

        public boolean accept(String param) {
            return true;
        }
    };
    private static final LazySelectableServiceLoader<String, NoiseValidator> validatorLoader = new LazySelectableServiceLoader<String, NoiseValidator>(defaultValidator){};
    private static final NoiseGenerator defaultGenerator = new NoiseGenerator(){

        @Override
        public String generateNoise() {
            return String.valueOf(Common.random((int)0, (int)Integer.MAX_VALUE));
        }

        public boolean accept(String param) {
            return true;
        }
    };
    private static final LazySelectableServiceLoader<String, NoiseGenerator> generatorLoader = new LazySelectableServiceLoader<String, NoiseGenerator>(defaultGenerator){};

    public static String getKeyId() {
        return SubjoinWrapper.getInstance().get(AbstractSignatureInterceptor.getPropertyName(KEY_FIELD_KEY_ID));
    }

    public static String getAlgorithm() {
        return SubjoinWrapper.getInstance().get(AbstractSignatureInterceptor.getPropertyName(KEY_FIELD_ALGORITHM));
    }

    public static String getSign() {
        return SubjoinWrapper.getInstance().get(AbstractSignatureInterceptor.getPropertyName(KEY_FIELD_SIGN));
    }

    public static String getNoise() {
        return SubjoinWrapper.getInstance().get(AbstractSignatureInterceptor.getPropertyName(KEY_FIELD_NOISE));
    }

    public static String methodToProperty(Method method) {
        if (method.getParameterTypes().length != 0) {
            return null;
        }
        if (method.getReturnType().equals(Void.TYPE) || method.getReturnType().equals(Void.class)) {
            return null;
        }
        if (method.getDeclaringClass().getName().startsWith("java")) {
            return null;
        }
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            return Common.lowerFirstChar((String)methodName.substring(3));
        }
        if (methodName.startsWith("is") && (method.getReturnType().equals(Boolean.TYPE) || method.getReturnType().equals(Boolean.class))) {
            return Common.lowerFirstChar((String)methodName.substring(2));
        }
        return null;
    }

    public static Map<String, Object> beanToMap(Object bean) throws InvocationTargetException, IllegalAccessException {
        Class<?> c = bean.getClass();
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        for (Method method : c.getMethods()) {
            String property = SignUtil.methodToProperty(method);
            if (property == null) continue;
            method.setAccessible(true);
            Object o = method.invoke(bean, new Object[0]);
            if (o == null) continue;
            objectMap.put(property, o);
        }
        return objectMap;
    }

    public static Map<String, Object> buildContent(DefinitionContext context, Object[] args) {
        Class<?> c;
        AUnit unit = AModule.getUnit(context.getDeclaringClass(), context.getDeclaringMethod());
        AbstractParam[] params = unit.getParameters();
        if (params == null) {
            return new HashMap<String, Object>();
        }
        if (!(params.length != 1 || Collection.class.isAssignableFrom(c = params[0].getType()) || c.isArray() || ConcreteHelper.isPrimitive(c))) {
            try {
                return SignUtil.beanToMap(args[0]);
            }
            catch (Throwable th) {
                throw ConcreteHelper.getException(th);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (AbstractParam param : unit.getParameters()) {
            result.put(param.getName(), args[param.getIndex()]);
        }
        return result;
    }

    private static String getString(Profile profile, String key, String paperName) {
        return Common.isBlank((String)paperName) ? profile.getString(key) : profile.getString(key + "." + paperName);
    }

    private static String getStr(String key, String paperName, String ... namespaces) {
        return Common.isBlank((String)paperName) ? Config.get((String)key, (String[])namespaces) : Config.get((String)(key + "." + paperName), (String[])namespaces);
    }

    public static NoiseValidator getNoiseValidator(String keyId) {
        NoiseValidator noiseValidator = (NoiseValidator)validatorLoader.select((Object)keyId);
        return noiseValidator == null ? defaultValidator : noiseValidator;
    }

    public static NoiseGenerator getNoiseGenerator(String keyId) {
        NoiseGenerator noiseGenerator = (NoiseGenerator)generatorLoader.select((Object)keyId);
        return noiseGenerator == null ? defaultGenerator : noiseGenerator;
    }

    public static String getString(String key, String paperName, String defaultValue) {
        String value;
        ServiceContext serviceContext = ConcreteContext.getServiceContext();
        String module = null;
        if (serviceContext instanceof ClientSideContext) {
            module = ((ClientSideContext)serviceContext).getDestination().getIdentify();
        }
        return (value = SignUtil.getStr(key, paperName, TAG_SIGNATURE, module, ConcreteHelper.getAppSet())) == null ? defaultValue : value;
    }

    public static HowToSign howToSign(Signable signable) {
        String algorithm = SignUtil.getString(KEY_FIELD_ALGORITHM, signable.paperName(), signable.algorithm());
        return new HowToSign((IronPenFactory)IRON_PEN_FACTORY_CONCRETE_SPI_FACADE.select((Object)algorithm), signable.serializer().equals(SignatureSerializer.class) ? DEFAULT_SERIALIZER : (SignatureSerializer)SIGNATURE_SERIALIZER_CONCRETE_SPI_FACADE.get(signable.serializer()), signable.paperName(), algorithm);
    }

    public static HowToSign howToSign(DefinitionContext context) {
        return SignUtil.howToSign((Signable)context.getAnnotation(Signable.class));
    }

    public static class HowToSign {
        private final IronPenFactory ironPenFactory;
        private final SignatureSerializer serializer;
        private final String paperName;
        private final String algorithm;

        HowToSign(IronPenFactory ironPenFactory, SignatureSerializer serializer, String paperName, String algorithm) {
            this.ironPenFactory = ironPenFactory;
            this.serializer = serializer;
            this.paperName = Common.isBlank((String)paperName) ? null : paperName;
            this.algorithm = algorithm;
        }

        public String getPaperName() {
            return this.paperName;
        }

        @Deprecated
        public IronPenFactory getIronPenFactory() {
            return this.getIronPenFactory(null);
        }

        public IronPenFactory getIronPenFactory(String algorithm) {
            return algorithm == null ? this.ironPenFactory : (IronPenFactory)IRON_PEN_FACTORY_CONCRETE_SPI_FACADE.select((Object)algorithm);
        }

        public SignatureSerializer getSerializer() {
            return this.serializer;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }
    }
}

