/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.message.serializers;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import org.coodex.concrete.common.JSONSerializerFactory;
import org.coodex.concrete.message.Serializer;
import org.coodex.util.Common;

public class JSonSerializer
implements Serializer {
    private static final String JSON = "json";

    @Override
    public byte[] serialize(Serializable o) {
        try {
            return JSONSerializerFactory.getInstance().toJson(o).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Common.rte((Throwable)e);
        }
    }

    @Override
    public <T extends Serializable> T deserialize(byte[] bytes, Type type) {
        try {
            return (T)((Serializable)JSONSerializerFactory.getInstance().parse(new String(bytes, "UTF-8"), type));
        }
        catch (UnsupportedEncodingException e) {
            throw Common.rte((Throwable)e);
        }
    }

    public boolean accept(String param) {
        return JSON.equalsIgnoreCase(param);
    }
}

