/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.coodex.concrete.common.JSONSerializerFactory;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.common.Warning;
import org.coodex.util.Common;

public abstract class AbstractSubjoin
implements Subjoin {
    private final Map<String, List<String>> stringMap = new HashMap<String, List<String>>();
    private final Set<Warning> warnings = new HashSet<Warning>();

    protected AbstractSubjoin() {
        this(null);
    }

    public AbstractSubjoin(Map<String, String> map) {
        if (map == null) {
            return;
        }
        Collection<String> skipKeys = this.skipKeys();
        for (String key : map.keySet()) {
            String v;
            if (skipKeys != null && skipKeys.contains(key) || (v = map.get(key)) == null) continue;
            this.set(key, Common.toArray((String)v, (String)"; ", new ArrayList()));
        }
    }

    protected abstract Collection<String> skipKeys();

    public String get(String name) {
        return this.get(name, "; ");
    }

    public String get(String name, String split) {
        return Common.concat(this.getList(name), (String)split);
    }

    public List<String> getList(String name) {
        return this.stringMap.get(name);
    }

    public Set<String> keySet() {
        return this.stringMap.keySet();
    }

    public void set(String name, List<String> values) {
        if (values == null || values.size() == 0) {
            this.stringMap.remove(name);
        } else {
            this.stringMap.put(name, new ArrayList<String>(values));
        }
    }

    public void add(String name, String value) {
        List list = this.stringMap.computeIfAbsent(name, k -> new ArrayList());
        list.add(value);
    }

    protected boolean containsKey(String name) {
        return this.stringMap.containsKey(name);
    }

    public Set<String> updatedKeySet() {
        return this.stringMap.keySet();
    }

    public void clearWarning() {
        this.warnings.clear();
        this.warningsUpdate();
    }

    public void setWarnings(@NotNull Collection<Warning> warings) {
        this.warnings.clear();
        this.addAll(this.warnings);
    }

    private void warningsUpdate() {
        if (this.warnings == null || this.warnings.size() == 0) {
            this.set("CONCRETE-WARNINGS", null);
        } else {
            this.set("CONCRETE-WARNINGS", Collections.singletonList(JSONSerializerFactory.getInstance().toJson(this.warnings)));
        }
    }

    public void addAll(Collection<Warning> warnings) {
        this.warnings.addAll(warnings);
        this.warningsUpdate();
    }

    public void putWarning(Warning warning) {
        this.warnings.add(warning);
        this.warningsUpdate();
    }
}

