/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.lang.reflect.Field;
import org.coodex.concrete.common.ErrorMessageFacade;

public class ErrorDefinition
implements Comparable<ErrorDefinition> {
    private final Integer errorCode;
    private final String errorMessage;
    private final String key;
    private final String fieldName;
    private final Class<?> declaringClass;

    public ErrorDefinition(Field field) {
        try {
            this.errorCode = field.getInt(null);
            this.fieldName = field.getName();
            this.declaringClass = field.getDeclaringClass();
            this.key = ErrorMessageFacade.getKey(this.errorCode);
            this.errorMessage = ErrorMessageFacade.getTemplate(this.errorCode);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public int compareTo(ErrorDefinition o) {
        return this.errorCode.compareTo(o.errorCode);
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        return "ErrorDefinition{errorCode=" + this.errorCode + ", errorMessage='" + this.errorMessage + '\'' + ", key='" + this.key + '\'' + ", fieldName='" + this.fieldName + '\'' + ", declaringClass=" + this.declaringClass + '}';
    }
}

