/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.coodex.concrete.api.ErrorCode;
import org.coodex.concrete.common.ErrorDefinition;
import org.coodex.concrete.common.KeyStat;
import org.coodex.util.Common;
import org.coodex.util.I18N;
import org.coodex.util.Renderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorMessageFacade {
    static final ThreadLocal<Locale> LOCALE_CONTEXT = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger(ErrorMessageFacade.class);
    private static final Set<Class<?>> REGISTERED = new HashSet();
    private static final Map<Integer, Field> errorCodes = new HashMap<Integer, Field>();

    private ErrorMessageFacade() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean registerClass(Class<?> clz) {
        if (clz == null || clz.getAnnotation(ErrorCode.class) == null) {
            return false;
        }
        if (!REGISTERED.contains(clz)) {
            Map<Integer, Field> map = errorCodes;
            synchronized (map) {
                if (!REGISTERED.contains(clz)) {
                    for (Field f : clz.getDeclaredFields()) {
                        if (!Integer.TYPE.equals(f.getType()) || !Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !Modifier.isPublic(f.getModifiers())) continue;
                        f.setAccessible(true);
                        try {
                            int code = f.getInt(null);
                            if (errorCodes.containsKey(code)) {
                                Field field = errorCodes.get(code);
                                if (field.equals(f)) continue;
                                log.warn("errorCode duplicate {}.{} and {}.{}", new Object[]{field.getDeclaringClass().getCanonicalName(), field.getName(), f.getDeclaringClass().getCanonicalName(), f.getName()});
                                continue;
                            }
                            errorCodes.put(code, f);
                        }
                        catch (IllegalAccessException e) {
                            log.warn("Cannot bind errorCode: {}.{}", (Object)f.getDeclaringClass().getCanonicalName(), (Object)f.getName());
                        }
                    }
                    REGISTERED.add(clz);
                    log.info("ErrorCode registered: {}", (Object)clz.getName());
                }
            }
        }
        return true;
    }

    public static boolean register(Class<?> clz) {
        return ErrorMessageFacade.registerClass(clz);
    }

    public static Set<Integer> allRegisteredErrorCodes() {
        return errorCodes.keySet();
    }

    public static String getMessageTemplate(int code) {
        return ErrorMessageFacade.getMessageOrPattern(false, code, new Object[0]);
    }

    public static String getMessage(int code, Object ... objects) {
        return ErrorMessageFacade.getMessageOrPattern(true, code, objects);
    }

    private static String getNamespace(Field field) {
        return Optional.ofNullable(field).map(f -> f.getDeclaringClass().getAnnotation(ErrorCode.class)).map(ec -> Common.isBlank((String)ec.value()) ? null : ec.value()).orElse("message");
    }

    private static String getKey(Field field, String namespace, int code) {
        String keyFromTemplate = ErrorMessageFacade.getKeyFromTemplate(ErrorMessageFacade.getTemplateStr(field));
        if (keyFromTemplate != null) {
            return keyFromTemplate;
        }
        return namespace + "." + Optional.ofNullable(field).map(f -> f.getAnnotation(ErrorCode.Key.class)).map(key -> Common.isBlank((String)key.value()) ? null : key.value()).orElse(String.valueOf(code));
    }

    private static String getKeyFromTemplate(String template) {
        return new KeyStat(template).key();
    }

    private static String getTemplateStr(Field field) {
        return Optional.ofNullable(field).map(f -> f.getAnnotation(ErrorCode.Template.class)).map(t -> Common.isBlank((String)t.value()) ? null : t.value()).orElse(null);
    }

    public static String getKey(int code) {
        Field f = errorCodes.get(code);
        return ErrorMessageFacade.getKey(f, ErrorMessageFacade.getNamespace(f), code);
    }

    public static String getTemplate(int code) {
        Field f = errorCodes.get(code);
        String template = ErrorMessageFacade.getTemplateStr(f);
        if (template == null) {
            return I18N.translate((String)ErrorMessageFacade.getKey(code), (Locale)LOCALE_CONTEXT.get());
        }
        return Optional.ofNullable(ErrorMessageFacade.getKeyFromTemplate(template)).map(key -> I18N.translate((String)key, (Locale)LOCALE_CONTEXT.get())).orElse(template);
    }

    private static String getMessageOrPattern(boolean format, int code, Object ... objects) {
        String template = ErrorMessageFacade.getTemplate(code);
        return format ? Renderer.render((String)template, (Object[])objects) : template;
    }

    public static List<ErrorDefinition> getAllErrorInfo() {
        return errorCodes.values().stream().map(ErrorDefinition::new).sorted().collect(Collectors.toList());
    }
}

