/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

class KeyStat {
    private boolean dot = false;
    private boolean hyphen = false;
    private int dotFound = 0;
    private StringBuilder builder = null;

    KeyStat(String template) {
        if (template == null) {
            return;
        }
        char[] chars = template.trim().toCharArray();
        if (chars.length < 5) {
            return;
        }
        if (chars[0] == '{' && chars[chars.length - 1] == '}') {
            if (chars[1] >= '0' && chars[1] <= '9') {
                return;
            }
            for (int i = 1; i < chars.length - 1; ++i) {
                if (!this.next(chars[i])) {
                    this.builder = null;
                    break;
                }
                this.builder = (this.builder == null ? new StringBuilder() : this.builder).append(chars[i]);
            }
            if (this.dotFound == 0) {
                this.builder = null;
            }
        }
    }

    public String key() {
        return this.builder == null ? null : this.builder.toString();
    }

    private Type typeOf(char c) {
        if (c == '.') {
            return Type.DOT;
        }
        if (c == '-' || c == '_') {
            return Type.HYPHEN;
        }
        if (c >= '0' && c <= '9') {
            return Type.ASCII_CHAR;
        }
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            return Type.ASCII_CHAR;
        }
        return Type.OTHER;
    }

    private boolean next(char c) {
        switch (this.typeOf(c)) {
            case ASCII_CHAR: {
                this.dot = true;
                this.hyphen = true;
                return true;
            }
            case DOT: {
                if (!this.dot) {
                    return false;
                }
                ++this.dotFound;
                this.dot = false;
                this.hyphen = false;
                return true;
            }
            case HYPHEN: {
                if (!this.hyphen) {
                    return false;
                }
                this.dot = false;
                return true;
            }
        }
        return false;
    }

    static enum Type {
        DOT,
        ASCII_CHAR,
        HYPHEN,
        OTHER;

    }
}

