/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import java.util.Collection;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.executable.ExecutableValidator;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.ViolationsFormatter;
import org.coodex.concrete.core.intercept.AbstractInterceptor;
import org.coodex.concrete.core.intercept.annotations.Local;
import org.coodex.concrete.core.intercept.annotations.ServerSide;
import org.coodex.concrete.core.intercept.annotations.TestContext;
import org.coodex.config.Config;
import org.coodex.util.LazyServiceLoader;
import org.coodex.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerSide
@TestContext
@Local
public class BeanValidationInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BeanValidationInterceptor.class);
    private static final ViolationsFormatter DEFAULT_FORMMATER = new ViolationsFormatter(){

        @Override
        public <T> String format(Collection<ConstraintViolation<T>> violations) {
            StringBuilder buf = new StringBuilder();
            for (ConstraintViolation<T> violation : violations) {
                buf.append(violation.getMessage()).append("\n");
            }
            return buf.toString();
        }
    };
    private static final ServiceLoader<ViolationsFormatter> VIOLATIONS_FORMATTER_SPI = new LazyServiceLoader<ViolationsFormatter>(DEFAULT_FORMMATER){};
    private ExecutableValidator executableValidator = null;
    private boolean hasProvider = true;

    private ExecutableValidator getValidator() {
        if (this.executableValidator == null && this.hasProvider) {
            try {
                this.executableValidator = Validation.buildDefaultValidatorFactory().getValidator().forExecutables();
            }
            catch (Throwable t) {
                this.hasProvider = false;
                log.warn("Failed to load validation provider: {}", (Object)t.getLocalizedMessage());
            }
        }
        return this.executableValidator;
    }

    public void checkViolations(Set<ConstraintViolation<Object>> constraintViolations) {
        if (constraintViolations.size() > 0) {
            throw new ConcreteException(1009, ((ViolationsFormatter)VIOLATIONS_FORMATTER_SPI.get()).format(constraintViolations));
        }
    }

    @Override
    public int getOrder() {
        return 1000;
    }

    @Override
    protected boolean accept_(DefinitionContext context) {
        return (Boolean)Config.getValue((String)"aspect.bean.validation", (Object)true, (String[])new String[]{ConcreteHelper.getAppSet()}) != false && this.getValidator() != null;
    }

    @Override
    public void before(DefinitionContext context, MethodInvocation joinPoint) {
        ExecutableValidator validator = this.getValidator();
        if (validator != null && context.getDeclaringMethod().getParameterTypes().length > 0) {
            this.checkViolations(validator.validateParameters(joinPoint.getThis(), context.getDeclaringMethod(), joinPoint.getArguments(), new Class[0]));
        }
    }
}

