/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.common.SubjoinWrapper;
import org.coodex.concrete.common.Warning;
import org.coodex.concrete.common.WarningData;
import org.coodex.concrete.core.intercept.AbstractSyncInterceptor;
import org.coodex.concrete.core.intercept.annotations.ServerSide;

@ServerSide
public class DeprecatedCheckInterceptor
extends AbstractSyncInterceptor {
    private static ThreadLocal<Boolean> checking = new ThreadLocal();
    private Subjoin subjoin = SubjoinWrapper.getInstance();

    @Override
    protected boolean accept_(DefinitionContext context) {
        return context.getAnnotation(Deprecated.class) != null;
    }

    @Override
    public void before(DefinitionContext context, MethodInvocation joinPoint) {
        if (checking.get() == null) {
            checking.set(true);
            try {
                if (context.getDeclaringClass().getAnnotation(Deprecated.class) != null) {
                    this.subjoin.putWarning((Warning)new WarningData(1300, context.getModuleName()));
                }
                if (context.getDeclaringMethod().getAnnotation(Deprecated.class) != null) {
                    this.subjoin.putWarning((Warning)new WarningData(1300, context.getDeclaringMethod().toGenericString()));
                }
                super.before(context, joinPoint);
            }
            finally {
                checking.remove();
            }
        } else {
            super.before(context, joinPoint);
        }
    }

    @Override
    public int getOrder() {
        return 101;
    }
}

