/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.signature;

import java.util.ArrayList;
import org.coodex.concrete.client.ClientSideContext;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.core.signature.HMAC_KeyStore;
import org.coodex.config.Config;
import org.coodex.util.Common;

public class HMAC_KeyStoreDefaultImpl
implements HMAC_KeyStore {
    private static String getHmacKeyStr(String paperName, String keyId, String module) {
        ArrayList<String> namespace = new ArrayList<String>();
        namespace.add(module == null ? "signature" : "client");
        if (module != null) {
            namespace.add(module);
        }
        namespace.add(ConcreteHelper.getAppSet());
        String[] namespaceArray = namespace.toArray(new String[0]);
        boolean blankPaper = Common.isBlank((String)paperName);
        String hmacKeyProperty = module == null ? "hmacKey" : "signature.hmacKey";
        String key = null;
        if (Common.isBlank((String)keyId)) {
            if (!blankPaper) {
                key = Config.get((String)String.format("%s.%s", hmacKeyProperty, paperName), (String[])namespaceArray);
            }
            if (key == null) {
                key = Config.get((String)hmacKeyProperty, (String[])namespaceArray);
            }
        } else {
            key = Config.get((String)String.format("%s.%s", hmacKeyProperty, (blankPaper ? "" : paperName + ".") + keyId), (String[])namespaceArray);
            if (key == null) {
                key = Config.get((String)(hmacKeyProperty + (blankPaper ? "" : "." + paperName)), (String[])namespaceArray);
            }
        }
        return key;
    }

    private String getModule() {
        ServiceContext context = ConcreteContext.getServiceContext();
        return context instanceof ClientSideContext ? ((ClientSideContext)context).getDestination().getIdentify() : null;
    }

    @Override
    public byte[] getHmacKey(String paperName, String keyId) {
        String s = HMAC_KeyStoreDefaultImpl.getHmacKeyStr(paperName, keyId, this.getModule());
        if (s != null) {
            return s.getBytes();
        }
        return null;
    }

    public boolean accept(ServiceContext param) {
        return true;
    }
}

