/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apm;

import java.util.Stack;
import org.coodex.concrete.apm.Trace;

public abstract class AbstractTrace
implements Trace {
    private static final ThreadLocal<Stack<AbstractTrace>> stackThreadLocal = new ThreadLocal();

    @Override
    public final Trace start() {
        return this.start(null);
    }

    protected abstract void actualStart(String var1);

    private Stack<AbstractTrace> getStack() {
        if (stackThreadLocal.get() == null) {
            stackThreadLocal.set(new Stack());
        }
        return stackThreadLocal.get();
    }

    private AbstractTrace current() {
        Stack<AbstractTrace> stack = this.getStack();
        return stack.isEmpty() ? null : stack.peek();
    }

    @Override
    public final Trace start(String name) {
        this.getStack().push(this);
        this.actualStart(name);
        return this;
    }

    @Override
    public final void finish() {
        while (!this.getStack().isEmpty()) {
            AbstractTrace trace = this.current();
            if (trace != null && trace != this) {
                trace.finish();
                continue;
            }
            this.getStack().pop();
            break;
        }
        stackThreadLocal.remove();
        this.actualFinish();
    }

    protected abstract void actualFinish();
}

