/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.util.HashSet;
import java.util.Map;
import org.coodex.concrete.common.BeanProvider;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ConflictSolution;
import org.coodex.concrete.common.conflictsolutions.ThrowException;
import org.coodex.config.Config;
import org.coodex.util.LazySelectableServiceLoader;

public abstract class AbstractBeanProvider
implements BeanProvider {
    public static final String CREATE_BY_CONCRETE = "cbc_";
    private static final ConflictSolution DEFAULT_CONFLICT_SOLUTION = new ThrowException();
    private static final LazySelectableServiceLoader<Class<?>, ConflictSolution> SOLUTION_CONCRETE_SPI_FACADE = new LazySelectableServiceLoader<Class<?>, ConflictSolution>(){};

    private static ConflictSolution getSolution(Class<?> clz) {
        ConflictSolution conflictSolution = (ConflictSolution)SOLUTION_CONCRETE_SPI_FACADE.select(clz);
        if (conflictSolution != null) {
            return conflictSolution;
        }
        try {
            return (ConflictSolution)Class.forName(Config.get((String)ConflictSolution.class.getCanonicalName(), (String[])new String[]{ConcreteHelper.getAppSet()})).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            return DEFAULT_CONFLICT_SOLUTION;
        }
    }

    @Override
    public final <T> T getBean(Class<T> type) {
        Map<String, T> instanceMap = this.getBeansOfType(type);
        for (String name : new HashSet<String>(instanceMap.keySet())) {
            if (!name.startsWith(CREATE_BY_CONCRETE)) continue;
            instanceMap.remove(name);
        }
        switch (instanceMap.size()) {
            case 0: {
                throw new ConcreteException(1011, type.getName());
            }
            case 1: {
                return instanceMap.values().iterator().next();
            }
        }
        return AbstractBeanProvider.getSolution(type).conflict(instanceMap, type);
    }
}

