/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ErrorInfo;
import org.coodex.concrete.common.ThrowableMapper;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.SelectableServiceLoader;

public class ThrowableMapperFacade {
    private static final SelectableServiceLoader<Throwable, ThrowableMapper> mapperLoader = new LazySelectableServiceLoader<Throwable, ThrowableMapper>(){};

    public static ErrorInfo toErrorInfo(Throwable exception) {
        try {
            ConcreteException concreteException = ConcreteHelper.findException(exception);
            try {
                ThrowableMapper mapper;
                if (concreteException == null && (mapper = (ThrowableMapper)mapperLoader.select((Object)exception)) != null) {
                    return mapper.toErrorInfo(exception);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (concreteException == null) {
                concreteException = ConcreteHelper.getException(exception);
            }
            return new ErrorInfo(concreteException.getCode(), concreteException.getMessage());
        }
        catch (Throwable th) {
            return new ErrorInfo(99999, th.getLocalizedMessage());
        }
    }
}

