/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.client.ClientSideContext;
import org.coodex.concrete.client.LocalServiceContext;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.ServerSideContext;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.common.TestServiceContext;
import org.coodex.concrete.core.intercept.ConcreteInterceptor;
import org.coodex.concrete.core.intercept.ConcreteMethodInvocation;
import org.coodex.concrete.core.intercept.annotations.ClientSide;
import org.coodex.concrete.core.intercept.annotations.Default;
import org.coodex.concrete.core.intercept.annotations.Local;
import org.coodex.concrete.core.intercept.annotations.ServerSide;
import org.coodex.concrete.core.intercept.annotations.TestContext;

public abstract class AbstractInterceptor
implements ConcreteInterceptor {
    protected static final DefinitionContext getContext(MethodInvocation invocation) {
        if (invocation instanceof ConcreteMethodInvocation) {
            return ConcreteHelper.getDefinitionContext(((ConcreteMethodInvocation)invocation).getInterfaceClass(), invocation.getMethod());
        }
        throw new IllegalArgumentException("need ConcreteMethodInvocation. " + invocation);
    }

    protected static final boolean isServiceMethod(DefinitionContext context) {
        return ConcreteHelper.isConcreteService(context.getDeclaringMethod());
    }

    @Override
    public final boolean accept(DefinitionContext context) {
        return this.sideAccept() && this.accept_(context);
    }

    private boolean sideAccept() {
        ServiceContext serviceContext = ConcreteContext.getServiceContext();
        Class<?> clz = this.getClass();
        if (serviceContext instanceof ServerSideContext) {
            return clz.getAnnotation(ServerSide.class) != null;
        }
        if (serviceContext instanceof ClientSideContext) {
            return clz.getAnnotation(ClientSide.class) != null;
        }
        if (serviceContext instanceof LocalServiceContext) {
            return clz.getAnnotation(Local.class) != null;
        }
        if (serviceContext instanceof TestServiceContext) {
            return clz.getAnnotation(TestContext.class) != null;
        }
        return clz.getAnnotation(Default.class) != null || clz.getAnnotation(ServerSide.class) == null && clz.getAnnotation(ClientSide.class) == null && clz.getAnnotation(Default.class) == null;
    }

    protected abstract boolean accept_(DefinitionContext var1);

    @Override
    public void before(DefinitionContext context, MethodInvocation joinPoint) {
    }

    @Override
    public Object after(DefinitionContext context, MethodInvocation joinPoint, Object result) {
        return result;
    }

    @Override
    public Throwable onError(DefinitionContext context, MethodInvocation joinPoint, Throwable th) {
        return th;
    }
}

