/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.api.ServiceTiming;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.ServiceTimingChecker;
import org.coodex.concrete.core.intercept.AbstractInterceptor;
import org.coodex.concrete.core.intercept.annotations.Local;
import org.coodex.concrete.core.intercept.annotations.ServerSide;
import org.coodex.concrete.core.intercept.annotations.TestContext;
import org.coodex.concrete.core.intercept.timecheckers.ByTimeRange;
import org.coodex.concrete.core.intercept.timecheckers.ByWorkDay;
import org.coodex.config.Config;
import org.coodex.util.Common;
import org.coodex.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerSide
@TestContext
@Local
public class ServiceTimingInterceptor
extends AbstractInterceptor {
    public static final String NAMESPACE_SERVICE_TIMING = "service-timing";
    private static final Logger log = LoggerFactory.getLogger(ServiceTimingInterceptor.class);
    private static final Map<String, String> DEFAULT_CHECKERS = new HashMap<String, String>();
    private static final ServiceTimingChecker ALL_ALLOWED_CHECKER;

    private static ServiceTimingChecker loadCheckerInstance(String label) {
        String type = Config.get((String)(label + ".type"), (String[])new String[]{NAMESPACE_SERVICE_TIMING});
        if (Common.isBlank((String)type)) {
            log.warn("ServiceTiming validation rule not defined. : {} ", (Object)label);
            return ALL_ALLOWED_CHECKER;
        }
        String className = DEFAULT_CHECKERS.get((type = type.trim()).toUpperCase());
        if (className == null) {
            className = type;
        }
        try {
            Class<?> clz = Class.forName(className);
            Object o = clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field f : ReflectHelper.getAllDeclaredFields(clz)) {
                String s;
                f.setAccessible(true);
                if (Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers()) || !String.class.equals(f.getType()) || (s = Config.get((String)(label + "." + f.getName()), (String[])new String[]{NAMESPACE_SERVICE_TIMING})) == null) continue;
                f.set(o, s.trim());
            }
            return (ServiceTimingChecker)o;
        }
        catch (Throwable t) {
            log.warn("error occurred in ServiceTimingChecker initialization. {} :{}", (Object)t.getClass().getCanonicalName(), (Object)t.getLocalizedMessage());
            return ALL_ALLOWED_CHECKER;
        }
    }

    private static ServiceTimingChecker getValidator(ServiceTiming serviceTiming) {
        if (serviceTiming == null || serviceTiming.value().length == 0) {
            return ALL_ALLOWED_CHECKER;
        }
        return new ServiceTimingCheckerChain(serviceTiming);
    }

    @Override
    protected boolean accept_(DefinitionContext context) {
        return this.isTimingLimitService(context);
    }

    @Override
    public int getOrder() {
        return 200;
    }

    @Override
    public void before(DefinitionContext context, MethodInvocation joinPoint) {
        IF.not(ServiceTimingInterceptor.getValidator((ServiceTiming)context.getAnnotation(ServiceTiming.class)).isAllowed(), 1013, new Object[0]);
    }

    public boolean isTimingLimitService(DefinitionContext context) {
        return ServiceTimingInterceptor.isServiceMethod(context) && context.getAnnotation(ServiceTiming.class) != null;
    }

    static {
        DEFAULT_CHECKERS.put("TIMERANGE", ByTimeRange.class.getName());
        DEFAULT_CHECKERS.put("WORKDAY", ByWorkDay.class.getName());
        ALL_ALLOWED_CHECKER = () -> true;
    }

    private static class ServiceTimingCheckerChain
    implements ServiceTimingChecker {
        private final List<ServiceTimingChecker> chain = new ArrayList<ServiceTimingChecker>();

        ServiceTimingCheckerChain(ServiceTiming serviceTiming) {
            HashSet<String> keys = new HashSet<String>();
            for (String s : serviceTiming.value()) {
                if (Common.isBlank((String)s) || Common.isBlank((String)s.trim()) || keys.contains(s = s.trim())) continue;
                keys.add(s);
                this.chain.add(ServiceTimingInterceptor.loadCheckerInstance(s));
            }
        }

        public boolean isAllowed() {
            for (ServiceTimingChecker checker : this.chain) {
                if (checker.isAllowed()) continue;
                return false;
            }
            return true;
        }
    }
}

