/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import java.util.HashSet;
import java.util.Set;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.token.TokenWrapper;
import org.coodex.concrete.message.Subscription;
import org.coodex.concrete.message.TBMContainer;
import org.coodex.util.SingletonMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TBTSManager {
    private static final Logger log = LoggerFactory.getLogger(TBTSManager.class);
    private static final SingletonMap<String, Set<Subscription>> subscriptionsMap = SingletonMap.builder().function(key -> new HashSet()).build();

    TBTSManager() {
    }

    static void putSubscription(Subscription subscription) {
        if (subscription == null) {
            return;
        }
        Token token = TokenWrapper.getInstance();
        ((Set)subscriptionsMap.get((Object)token.getTokenId())).add(subscription);
    }

    static Object tokenLock(Token token) {
        return subscriptionsMap.get((Object)token.getTokenId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cancel(Token token) {
        Set set = (Set)subscriptionsMap.get((Object)token.getTokenId());
        if (set.size() != 0) {
            SingletonMap<String, Set<Subscription>> singletonMap = subscriptionsMap;
            synchronized (singletonMap) {
                for (Subscription subscription : set) {
                    subscription.cancel();
                }
                TBMContainer.getInstance().clear(token.getTokenId());
                subscriptionsMap.remove((Object)token.getTokenId());
                log.debug("token {} cancel {} subscription(s).", (Object)token.getTokenId(), (Object)set.size());
            }
        }
    }
}

