/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.token.sharedcache;

import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.token.TokenManager;
import org.coodex.concrete.core.token.sharedcache.SharedCacheToken;
import org.coodex.config.Config;
import org.coodex.sharedcache.SharedCacheClient;
import org.coodex.sharedcache.SharedCacheClientManager;
import org.coodex.util.UUIDHelper;

public class SharedCacheTokenManager
implements TokenManager {
    @Override
    public Token getToken(String id) {
        return this.getTokenById(id);
    }

    private Token getTokenById(String id) {
        String tokenCacheType = Config.get((String)"tokenCacheType", (String[])new String[]{ConcreteHelper.getAppSet()});
        SharedCacheClient client = SharedCacheClientManager.getClient((String)tokenCacheType);
        long maxIdleTime = (long)ConcreteHelper.getTokenMaxIdleInMinute().intValue() * 60L * 1000L;
        return new SharedCacheToken(client, id, maxIdleTime);
    }

    @Override
    public Token newToken() {
        return this.getTokenById(UUIDHelper.getUUIDString());
    }
}

