/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.core.token.TokenWrapper;
import org.coodex.concrete.message.MessageSubject;
import org.coodex.concrete.message.ServerSideMessage;
import org.coodex.concrete.message.Subject;
import org.coodex.concrete.message.TokenBasedTopicPrototype;
import org.coodex.concrete.message.Topic;
import org.coodex.config.Config;
import org.coodex.util.Common;
import org.coodex.util.JSONSerializer;
import org.coodex.util.SingletonMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TBMContainer {
    private static final Logger log = LoggerFactory.getLogger(TBMContainer.class);
    private static final TBMContainer tbmContainer = new TBMContainer();
    private static final SingletonMap<String, TBMQueue> queues = SingletonMap.builder().function(key -> new TBMQueue()).build();

    private TBMContainer() {
    }

    public static TBMContainer getInstance() {
        return tbmContainer;
    }

    private static void remove(String tokenId, TBMMessage message) {
        if (Common.isBlank((String)tokenId)) {
            return;
        }
        ((TBMQueue)queues.get((Object)tokenId)).remove(message);
        if (log.isDebugEnabled()) {
            log.debug("removed from token {}\n{}", (Object)tokenId, (Object)JSONSerializer.getInstance().toJson(message.message));
        }
    }

    void push(TokenBasedTopicPrototype.TokenConfirm<?> tokenConfirm, Topic<TokenBasedTopicPrototype.ConsumedNotify> consumedNotifyTopic) {
        if (Common.isBlank((String)tokenConfirm.getTokenId())) {
            return;
        }
        ((TBMQueue)queues.get((Object)tokenConfirm.getTokenId())).put(new TBMMessage(tokenConfirm, consumedNotifyTopic));
    }

    void remove(TokenBasedTopicPrototype.ConsumedNotify consumedNotify) {
        ((TBMQueue)queues.get((Object)consumedNotify.getTokenId())).remove(consumedNotify.getId());
    }

    public List<ServerSideMessage<?>> getMessages(String tokenId, long timeOut) {
        if (Common.isBlank((String)tokenId)) {
            if (timeOut > 0L) {
                Common.sleep((long)timeOut);
            }
            return new ArrayList();
        }
        List<TBMMessage> messageList = ((TBMQueue)queues.get((Object)tokenId)).peekAll(timeOut);
        ArrayList messages = new ArrayList();
        for (TBMMessage message : messageList) {
            message.consumeBy(tokenId);
            messages.add(new SSMImpl(message));
        }
        return messages;
    }

    public List<ServerSideMessage<?>> getMessages(long timeOut) {
        String tokenId = TokenWrapper.getInstance().getTokenId();
        return this.getMessages(tokenId, timeOut);
    }

    public void listen(String tokenId, TBMListener tbmListener) {
        TBMQueue queue = (TBMQueue)queues.get((Object)tokenId);
        queue.tbmListener = tbmListener;
    }

    public void clear(String tokenId) {
        TBMQueue queue = (TBMQueue)queues.remove((Object)tokenId);
        if (queue != null) {
            queue.tbmListener = null;
            queue.peekAll(0L);
        }
    }

    static class TBMMessage {
        private Object message;
        private String id;
        private Future<?> future;
        private Topic<TokenBasedTopicPrototype.ConsumedNotify> consumedNotifyTopic;

        public TBMMessage(TokenBasedTopicPrototype.TokenConfirm<?> tokenConfirm, Topic<TokenBasedTopicPrototype.ConsumedNotify> consumedNotifyTopic) {
            this.consumedNotifyTopic = consumedNotifyTopic;
            this.id = tokenConfirm.getId();
            this.message = tokenConfirm.getMessage();
            this.future = ConcreteHelper.getScheduler("tbm").schedule(() -> TBMContainer.remove(tokenConfirm.getTokenId(), this), (long)((Integer)Config.getValue((String)"tokenBasedTopicMessage.cacheLife", (Object)30, (String[])new String[]{ConcreteHelper.getAppSet()})).intValue(), TimeUnit.SECONDS);
        }

        void consumeBy(String tokenId) {
            this.consumedNotifyTopic.publish((Serializable)new TokenBasedTopicPrototype.ConsumedNotify(this.id, tokenId));
        }
    }

    static class TBMQueue {
        private final Queue<TBMMessage> queue = new LinkedBlockingQueue<TBMMessage>();
        private final Object lock = new Object();
        private Map<String, TBMMessage> index = new ConcurrentHashMap<String, TBMMessage>();
        private TBMListener tbmListener;

        TBMQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(TBMMessage message) {
            if (this.queue.contains(message)) {
                Queue<TBMMessage> queue = this.queue;
                synchronized (queue) {
                    if (this.queue.contains(message)) {
                        this.queue.remove(message);
                        this.index.remove(message.id);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(TBMMessage message) {
            Queue<TBMMessage> queue = this.queue;
            synchronized (queue) {
                if (this.tbmListener != null) {
                    message.consumeBy(this.tbmListener.getTokenId());
                    this.tbmListener.onMessage(new SSMImpl(message));
                } else {
                    this.queue.add(message);
                    this.index.put(message.id, message);
                }
                Object object = this.lock;
                synchronized (object) {
                    this.queue.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(String id) {
            if (this.index.containsKey(id)) {
                Queue<TBMMessage> queue = this.queue;
                synchronized (queue) {
                    this.remove(this.index.get(id));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<TBMMessage> peekAll(long timeOut) {
            Object object;
            List<TBMMessage> list = null;
            if (this.queue.size() == 0 && timeOut > 0L) {
                object = this.queue;
                synchronized (object) {
                    try {
                        this.queue.wait(timeOut);
                    }
                    catch (InterruptedException e) {
                        log.warn(e.getLocalizedMessage(), (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                }
            }
            if (this.queue.size() > 0) {
                object = this.lock;
                synchronized (object) {
                    list = Arrays.asList(this.queue.toArray(new TBMMessage[0]));
                    this.queue.clear();
                    this.index.clear();
                    for (TBMMessage message : list) {
                        message.future.cancel(true);
                    }
                }
            }
            return list == null ? Collections.emptyList() : list;
        }
    }

    static class SSMImpl
    implements ServerSideMessage<Object> {
        private String subject = null;
        private String host = null;
        private String id;
        private Object body;

        SSMImpl(TBMMessage message) {
            Class<?> clz;
            MessageSubject messageSubject;
            this.id = message.id;
            this.body = message.message;
            if (message.message instanceof Subject) {
                this.subject = ((Subject)message.message).getSubject();
            } else if (message.message != null && (messageSubject = (clz = message.message.getClass()).getAnnotation(MessageSubject.class)) != null) {
                this.subject = messageSubject.value();
            }
        }

        public String getSubject() {
            return this.subject;
        }

        public String getId() {
            return this.id;
        }

        public String getHost() {
            return this.host;
        }

        public Object getBody() {
            return this.body;
        }
    }

    public static interface TBMListener {
        public String getTokenId();

        public void onMessage(ServerSideMessage<?> var1);
    }
}

