/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.message.serializers;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.coodex.concrete.message.Serializer;
import org.coodex.util.JSONSerializer;

public class JSonSerializer
implements Serializer {
    private static final String JSON = "json";

    @Override
    public byte[] serialize(Serializable o) {
        return JSONSerializer.getInstance().toJson((Object)o).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public <T extends Serializable> T deserialize(byte[] bytes, Type type) {
        return (T)((Serializable)JSONSerializer.getInstance().parse(new String(bytes, StandardCharsets.UTF_8), type));
    }

    public boolean accept(String param) {
        return JSON.equalsIgnoreCase(param);
    }
}

