/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.protobuf;

import java.util.Optional;
import java.util.function.Consumer;
import org.coodex.concrete.common.Caller;
import org.coodex.concrete.common.ServerSideContext;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.own.OwnServiceProvider;
import org.coodex.concrete.own.RequestPackage;
import org.coodex.concrete.own.ResponsePackage;
import org.coodex.concrete.protobuf.Concrete;
import org.coodex.concrete.protobuf.ProtobufContext;
import org.coodex.concrete.protobuf.ProtobufModule;
import org.coodex.util.JSONSerializer;
import org.coodex.util.SingletonMap;

public class ProtobufServiceApplication
extends OwnServiceProvider {
    public static final String SUBJOIN_KEY_INVOKER = "x-invoker-provider";
    private static final SingletonMap<String, ProtobufServiceApplication> APPLICATIONS = SingletonMap.builder().function(ProtobufServiceApplication::new).build();
    private final String overProtocol;
    private OwnServiceProvider.OwnModuleBuilder ownModuleBuilder;

    private ProtobufServiceApplication(String overProtocol) {
        this.overProtocol = overProtocol;
    }

    public static ProtobufServiceApplication getInstance(String protocol) {
        return (ProtobufServiceApplication)APPLICATIONS.get((Object)protocol);
    }

    private static Concrete.ResponsePackage toResp(ResponsePackage<?> resp) {
        return Concrete.ResponsePackage.newBuilder().putAllSubjoin(resp.getSubjoin()).setContent(JSONSerializer.getInstance().toJson(resp.getContent())).setConcreteTokenId(Optional.ofNullable(resp.getConcreteTokenId()).orElse("")).setOk(resp.isOk()).build();
    }

    private static RequestPackage<Object> toReq(Concrete.RequestPackage req) {
        RequestPackage<Object> requestPackage = new RequestPackage<Object>();
        requestPackage.setServiceId(req.getServiceId());
        requestPackage.setContent(JSONSerializer.getInstance().parse(req.getContent(), Object.class));
        requestPackage.setConcreteTokenId(req.getConcreteTokenId());
        requestPackage.setSubjoin(req.getSubjoinMap());
        return requestPackage;
    }

    public String getNamespace() {
        return "protobuf.over." + this.overProtocol;
    }

    @Override
    protected OwnServiceProvider.OwnModuleBuilder getModuleBuilder() {
        if (this.ownModuleBuilder == null) {
            this.ownModuleBuilder = c -> new ProtobufModule(c, this.overProtocol);
        }
        return this.ownModuleBuilder;
    }

    @Override
    protected ServerSideContext getServerSideContext(RequestPackage<Object> requestPackage, String tokenId, Caller caller) {
        Subjoin subjoin = this.getSubjoin(requestPackage.getSubjoin());
        return new ProtobufContext(caller, subjoin, this.getLocale(subjoin), tokenId);
    }

    @Override
    protected String getModuleName() {
        return "protobuf.over." + this.overProtocol;
    }

    public void invokeService(final Concrete.RequestPackage requestPackage, final String remoteAddress, Consumer<Concrete.ResponsePackage> responsePackageConsumer) {
        this.invokeService(ProtobufServiceApplication.toReq(requestPackage), new Caller(){

            public String getAddress() {
                return remoteAddress;
            }

            public String getClientProvider() {
                return requestPackage.getSubjoinOrDefault(ProtobufServiceApplication.SUBJOIN_KEY_INVOKER, "unknown-client-invoker");
            }
        }, responsePackage -> responsePackageConsumer.accept(ProtobufServiceApplication.toResp(responsePackage)), null, null);
    }
}

