/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.serializer.jackson2;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import org.coodex.concrete.common.JSONSerializer;
import org.coodex.util.Common;

public class Jackson2Serializer
implements JSONSerializer {
    private ObjectMapper mapper;

    private synchronized ObjectMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
        }
        return this.mapper;
    }

    public <T> T parse(String json, Type t) {
        if (json == null) {
            return null;
        }
        try {
            if (t instanceof Class) {
                Class c = (Class)Common.cast((Object)t);
                return (T)this.getMapper().readValue(json, c);
            }
            return (T)this.getMapper().readValue(json, TypeFactory.defaultInstance().constructType(t));
        }
        catch (Throwable th) {
            throw th instanceof RuntimeException ? (RuntimeException)th : new RuntimeException(th);
        }
    }

    public String toJson(Object t) {
        try {
            return this.getMapper().writeValueAsString(t);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

